/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultMatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Literals;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedNull;

public class SimpleValueAdaptor
extends DefaultMatcherGenerator<SerializedValue>
implements MatcherGenerator<SerializedValue> {
    public boolean isSimpleValue(SerializedValue element) {
        return element instanceof SerializedNull || element instanceof SerializedLiteral;
    }

    @Override
    public Class<SerializedValue> getAdaptedClass() {
        return SerializedValue.class;
    }

    @Override
    public Computation tryDeserialize(SerializedValue value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        Type usedType = (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)Object.class)));
        if (value instanceof SerializedNull) {
            return Computation.expression("null", usedType);
        }
        if (value instanceof SerializedLiteral) {
            return Computation.expression(Literals.asLiteral((Object)((SerializedLiteral)value).getValue()), usedType);
        }
        return value.accept(generator);
    }
}

