/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.dynamiccompile;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import net.amygdalum.testrecorder.dynamiccompile.CompilationUnit;
import net.amygdalum.testrecorder.dynamiccompile.DynamicClassCompilerException;
import net.amygdalum.testrecorder.dynamiccompile.JavaInMemoryFileManager;
import net.amygdalum.testrecorder.dynamiccompile.JavaSourceFileObject;
import net.amygdalum.testrecorder.util.ExtensibleClassLoader;

public class DynamicClassCompiler {
    private static final Pattern PACKAGE = Pattern.compile("package\\s+((\\w+\\s*\\.\\s*)*\\w+)\\s*;");
    private static final Pattern NAME = Pattern.compile("public\\s+class\\s+(\\w+)");
    private ThreadLocal<Map<String, Class<?>>> compiled = ThreadLocal.withInitial(HashMap::new);
    private JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    public Class<?> compile(String sourceCode, ClassLoader loader) throws DynamicClassCompilerException {
        CompilationUnit unit = this.compile(loader, sourceCode);
        if (this.isCached(sourceCode)) {
            return this.fromCache(sourceCode);
        }
        JavaInMemoryFileManager fileManager = new JavaInMemoryFileManager(unit.getLoader(), this.compiler.getStandardFileManager(null, null, null));
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, fileManager, diagnostics, null, null, Arrays.asList(new JavaSourceFileObject(unit.getName(), sourceCode)));
        boolean success = task.call();
        if (!success) {
            throw new DynamicClassCompilerException("compile failed with messages", this.collectMessages(diagnostics.getDiagnostics()));
        }
        try {
            Class<?> clazz = fileManager.getClassLoader(null).loadClass(unit.getFullQualifiedName());
            this.cache(sourceCode, clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new DynamicClassCompilerException("class " + unit.getFullQualifiedName() + " cannot be loaded: " + e.getMessage());
        }
    }

    private CompilationUnit compile(ClassLoader loader, String sourceCode) throws DynamicClassCompilerException {
        String name = this.findName(sourceCode);
        String pkg = this.findPackage(sourceCode);
        ClassLoader extensibleloader = this.makeExtensible(loader, pkg);
        return new CompilationUnit(extensibleloader, pkg, name);
    }

    private ClassLoader makeExtensible(ClassLoader loader, String pkg) {
        if (loader instanceof ExtensibleClassLoader) {
            ((ExtensibleClassLoader)loader).addPackage(pkg);
            return loader;
        }
        return new ExtensibleClassLoader(loader, new String[]{pkg});
    }

    private List<String> collectMessages(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        return diagnostics.stream().map(diagnostic -> this.messageOf((Diagnostic<? extends JavaFileObject>)diagnostic)).collect(Collectors.toList());
    }

    private String messageOf(Diagnostic<? extends JavaFileObject> diagnostic) {
        return diagnostic.getLineNumber() + ":" + diagnostic.getColumnNumber() + "\t" + diagnostic.getMessage(Locale.getDefault());
    }

    private boolean isCached(String sourceCode) {
        return this.compiled.get().containsKey(sourceCode);
    }

    private Class<?> fromCache(String sourceCode) {
        return this.compiled.get().get(sourceCode);
    }

    private void cache(String sourceCode, Class<?> clazz) {
        this.compiled.get().put(sourceCode, clazz);
    }

    private String findPackage(String item) throws DynamicClassCompilerException {
        Matcher packageMatcher = PACKAGE.matcher(item);
        boolean packageFound = packageMatcher.find();
        if (!packageFound) {
            throw new DynamicClassCompilerException("given code contains no package declaration");
        }
        return packageMatcher.group(1);
    }

    private String findName(String item) throws DynamicClassCompilerException {
        Matcher nameMatcher = NAME.matcher(item);
        boolean nameFound = nameMatcher.find();
        if (!nameFound) {
            throw new DynamicClassCompilerException("given code contains no public class");
        }
        return nameMatcher.group(1);
    }
}

