/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.dynamiccompile;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import net.amygdalum.testrecorder.dynamiccompile.JavaClassFileObject;
import net.amygdalum.testrecorder.util.RedefiningClassLoader;

public class JavaInMemoryFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private List<JavaClassFileObject> files;
    private ClassLoader loader;

    public JavaInMemoryFileManager(ClassLoader loader, JavaFileManager fileManager) {
        super(fileManager);
        this.loader = loader;
        this.files = new ArrayList<JavaClassFileObject>();
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            JavaClassFileObject file = new JavaClassFileObject(className);
            this.files.add(file);
            return file;
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        if (this.loader instanceof RedefiningClassLoader) {
            RedefiningClassLoader instrumentedLoader = (RedefiningClassLoader)this.loader;
            for (JavaClassFileObject file : this.files) {
                String name;
                byte[] bytes = file.getBytes();
                if (bytes == null || bytes.length <= 0 || instrumentedLoader.isRedefined(name = file.getClassName())) continue;
                instrumentedLoader.define(name, bytes);
            }
        }
        this.files.clear();
        return new URLClassLoader(new URL[0], this.loader);
    }
}

