/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.evaluator;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.evaluator.Expression;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedObject;

public class FieldExpression
implements Expression {
    private String field;

    public FieldExpression(String field) {
        this.field = field;
    }

    @Override
    public Optional<SerializedValue> evaluate(SerializedValue base) {
        return this.evaluate(base, null);
    }

    @Override
    public Optional<SerializedValue> evaluate(SerializedValue base, Class<?> type) {
        if (base instanceof SerializedObject) {
            SerializedObject object = (SerializedObject)base;
            Stream<SerializedField> selector = object.getFields().stream().filter(f -> f.getName().equals(this.field));
            if (type != null) {
                selector = selector.filter(f -> type.isAssignableFrom(Types.boxedType((Type)f.getType())));
            }
            return selector.map(f -> f.getValue()).findFirst();
        }
        return Optional.empty();
    }
}

