/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.evaluator;

import java.lang.reflect.Type;
import java.util.Optional;
import net.amygdalum.testrecorder.evaluator.Expression;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedList;

public class IndexExpression
implements Expression {
    private int index;

    public IndexExpression(int index) {
        this.index = index;
    }

    @Override
    public Optional<SerializedValue> evaluate(SerializedValue base) {
        return this.evaluate(base, null);
    }

    @Override
    public Optional<SerializedValue> evaluate(SerializedValue base, Class<?> type) {
        if (base instanceof SerializedArray) {
            return this.applyIndexToArray(type, (SerializedArray)base);
        }
        if (base instanceof SerializedList) {
            return this.applyIndexToList(type, (SerializedList)base);
        }
        return Optional.empty();
    }

    private Optional<SerializedValue> applyIndexToArray(Class<?> type, SerializedArray array) {
        if (!this.isApplicable(type, array.getComponentType(), array.size())) {
            return Optional.empty();
        }
        return Optional.of(array.get(this.index));
    }

    private Optional<SerializedValue> applyIndexToList(Class<?> type, SerializedList list) {
        if (!this.isApplicable(type, list.getComponentType(), list.size())) {
            return Optional.empty();
        }
        return Optional.of(list.get(this.index));
    }

    private boolean isApplicable(Class<?> type, Type componentType, int size) {
        if (type != null && !type.isAssignableFrom(Types.boxedType((Type)componentType))) {
            return false;
        }
        return this.index >= 0 && this.index < size;
    }
}

