/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.evaluator;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.StringTokenizer;
import net.amygdalum.testrecorder.evaluator.Expression;
import net.amygdalum.testrecorder.evaluator.FieldExpression;
import net.amygdalum.testrecorder.evaluator.IndexExpression;
import net.amygdalum.testrecorder.evaluator.ParseFailedExpression;
import net.amygdalum.testrecorder.types.SerializedValue;

public class SerializedValueEvaluator {
    private Expression[] parsed;
    private Class<?> type;

    public SerializedValueEvaluator(String expression) {
        this.parsed = SerializedValueEvaluator.parse(expression);
    }

    public SerializedValueEvaluator(String expression, Class<?> type) {
        this.parsed = SerializedValueEvaluator.parse(expression);
        this.type = type;
    }

    private static Expression[] parse(String expression) {
        try {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            StringTokenizer tokenizer = new StringTokenizer(expression, ".[]", true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (".".equals(token)) {
                    expressions.add(new FieldExpression(SerializedValueEvaluator.nextString(tokenizer, "<field>")));
                    continue;
                }
                if ("[".equals(token)) {
                    expressions.add(new IndexExpression(SerializedValueEvaluator.nextInt(tokenizer, "<index>")));
                    String nextToken = SerializedValueEvaluator.nextString(tokenizer, "']'");
                    if (nextToken.equals("]")) continue;
                    throw new ParseException("expecting ']', but found: '" + nextToken + "'", 0);
                }
                throw new ParseException("expecting '.' or '[', but found: '" + token + "'", 0);
            }
            return expressions.toArray(new Expression[expressions.size()]);
        }
        catch (ParseException e) {
            return new Expression[]{new ParseFailedExpression(e.getMessage())};
        }
    }

    private static String nextString(StringTokenizer tokenizer, String expression) throws ParseException {
        if (tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken();
        }
        throw new ParseException("expecting " + expression + ", but nothing found", 0);
    }

    private static int nextInt(StringTokenizer tokenizer, String expression) throws ParseException {
        if (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            try {
                return Integer.parseInt(nextToken);
            }
            catch (NumberFormatException e) {
                throw new ParseException("expecting " + expression + ", but found: '" + nextToken + "'", 0);
            }
        }
        throw new ParseException("expecting " + expression + ", but nothing found", 0);
    }

    public Optional<SerializedValue> applyTo(SerializedValue value) {
        Optional<SerializedValue> result = Optional.ofNullable(value);
        if (this.parsed.length == 0) {
            if (this.type != null) {
                result = result.filter(v -> this.type.isAssignableFrom(v.getType()));
            }
            return result;
        }
        int last = this.parsed.length - 1;
        for (int i = 0; i < last; ++i) {
            Expression expression = this.parsed[i];
            result = result.flatMap(expression::evaluate);
        }
        Expression expression = this.parsed[last];
        result = this.type == null ? result.flatMap(expression::evaluate) : result.flatMap(v -> expression.evaluate((SerializedValue)v, this.type));
        return result;
    }

    public Optional<ParseFailedExpression> error() {
        if (this.parsed.length > 0 && this.parsed[0] instanceof ParseFailedExpression) {
            return Optional.of((ParseFailedExpression)this.parsed[0]);
        }
        return Optional.empty();
    }
}

