/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.generator;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.amygdalum.testrecorder.deserializers.CustomAnnotation;
import net.amygdalum.testrecorder.deserializers.DeserializerFactory;
import net.amygdalum.testrecorder.deserializers.DeserializerTypeManager;
import net.amygdalum.testrecorder.generator.MethodGenerator;
import net.amygdalum.testrecorder.generator.SetupGenerator;
import net.amygdalum.testrecorder.generator.TestTemplate;
import net.amygdalum.testrecorder.types.ContextSnapshot;
import net.amygdalum.testrecorder.types.TypeManager;

public class ClassGenerator {
    private String testName;
    private TestTemplate template;
    private DeserializerFactory setup;
    private DeserializerFactory matcher;
    private List<CustomAnnotation> annotations;
    private TypeManager types;
    private Map<String, String> setups;
    private Set<String> tests;

    public ClassGenerator(DeserializerFactory setup, DeserializerFactory matcher, TestTemplate template, List<CustomAnnotation> annotations, String pkg, String testName) {
        this.testName = testName;
        this.template = template;
        this.setup = setup;
        this.matcher = matcher;
        this.annotations = annotations;
        this.types = new DeserializerTypeManager(pkg);
        this.setups = new LinkedHashMap<String, String>();
        this.tests = new LinkedHashSet<String>();
        this.types.registerTypes(template.getTypes());
    }

    public String getTestName() {
        return this.testName;
    }

    public synchronized Set<String> getTests() {
        return this.tests;
    }

    public synchronized int size() {
        return this.tests.size();
    }

    public synchronized void addSetup(String key, String setup) {
        this.setups.put(key, setup);
    }

    public synchronized void add(String test) {
        this.tests.add(test);
    }

    public void generate(ContextSnapshot snapshot) {
        if (snapshot.hasSetupInput() || snapshot.hasExpectOutput()) {
            SetupGenerator setupGenerator = new SetupGenerator(this.types, "resetFakeIO", this.template, this.annotations).generateReset();
            this.addSetup("resetFakeIO", setupGenerator.generateSetup());
        }
        MethodGenerator methodGenerator = new MethodGenerator(this.size(), this.types, this.setup, this.matcher, this.template, this.annotations).analyze(snapshot).generateArrange().generateAct().generateAssert();
        this.add(methodGenerator.generateTest());
    }

    public String render() {
        return this.template.testClass(this.testName, this.types, this.setups, this.tests);
    }
}

