/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.generator;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.amygdalum.testrecorder.generator.TestTemplate;
import net.amygdalum.testrecorder.types.TypeManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.stringtemplate.v4.ST;

public class JUnit4TestTemplate
implements TestTemplate {
    private static final String CLASS_TEMPLATE = "package <package>;\n\n<imports: {pkg | import <pkg>;\n}>\n\n\n@SuppressWarnings(\"unused\")\npublic class <className> {\n\n  <setup; separator=\"\\n\">\n\n  <methods; separator=\"\\n\">\n}";
    private static final String SETUP_TEMPLATE = "@Before\n@After\n<annotations;separator=\"\\n\">\npublic void <name>() throws Exception {\n  <statements;separator=\"\\n\">\n}\n";
    private static final String TEST_TEMPLATE = "@Test\n<annotations:{annotation | <annotation>\n}>public void test<testName>() throws Exception {\n  <statements;separator=\"\\n\">\n}\n";

    @Override
    public Class<?>[] getTypes() {
        return new Class[]{Before.class, After.class, Test.class};
    }

    @Override
    public String testClass(String testName, TypeManager types, Map<String, String> setups, Set<String> tests) {
        ST file = new ST(CLASS_TEMPLATE);
        file.add("package", (Object)types.getPackage());
        file.add("className", (Object)testName);
        file.add("setup", setups.values());
        file.add("methods", tests);
        file.add("imports", types.getImports());
        return file.render();
    }

    @Override
    public String setupMethod(String methodName, TypeManager types, List<String> annotations, List<String> statements) {
        ST test = new ST(SETUP_TEMPLATE);
        test.add("annotations", annotations);
        test.add("name", (Object)methodName);
        test.add("statements", statements);
        return test.render();
    }

    @Override
    public String testMethod(String methodName, TypeManager types, List<String> annotations, List<String> statements) {
        ST test = new ST(TEST_TEMPLATE);
        test.add("annotations", annotations);
        test.add("testName", (Object)methodName);
        test.add("statements", statements);
        return test.render();
    }
}

