/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.generator;

import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.MockedInteractions;
import net.amygdalum.testrecorder.deserializers.CustomAnnotation;
import net.amygdalum.testrecorder.deserializers.DefaultDeserializerContext;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.DeserializerFactory;
import net.amygdalum.testrecorder.deserializers.ReferenceAnalyzer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TreeAnalyzer;
import net.amygdalum.testrecorder.evaluator.SerializedValueEvaluator;
import net.amygdalum.testrecorder.generator.TestTemplate;
import net.amygdalum.testrecorder.hints.AnnotateGroupExpression;
import net.amygdalum.testrecorder.hints.AnnotateTimestamp;
import net.amygdalum.testrecorder.runtime.Throwables;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.ContextSnapshot;
import net.amygdalum.testrecorder.types.GenericsResolver;
import net.amygdalum.testrecorder.types.LocalVariableNameGenerator;
import net.amygdalum.testrecorder.types.SerializedArgument;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedImmutableType;
import net.amygdalum.testrecorder.types.SerializedResult;
import net.amygdalum.testrecorder.types.SerializedRole;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.AnnotatedBy;
import net.amygdalum.testrecorder.util.Literals;
import net.amygdalum.testrecorder.util.Pair;
import net.amygdalum.testrecorder.util.Triple;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import org.hamcrest.MatcherAssert;

public class MethodGenerator {
    private static final Set<Class<?>> LITERAL_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Float.class, Long.class, Double.class, String.class));
    private static final String BEGIN_ARRANGE = "\n//Arrange";
    private static final String BEGIN_ACT = "\n//Act";
    private static final String BEGIN_ASSERT = "\n//Assert";
    private DeserializerFactory setup;
    private DeserializerFactory matcher;
    private List<CustomAnnotation> annotations;
    private LocalVariableNameGenerator locals;
    private GenericsResolver resolver;
    private int no;
    private ContextSnapshot snapshot;
    private DefaultDeserializerContext context;
    private TypeManager types;
    private TestTemplate template;
    private MockedInteractions mocked;
    private List<String> statements;
    private String base;
    private List<String> args;
    private String result;
    private String error;

    public MethodGenerator(int no, TypeManager types, DeserializerFactory setup, DeserializerFactory matcher, TestTemplate template, List<CustomAnnotation> annotations) {
        this.no = no;
        this.types = types;
        this.setup = setup;
        this.matcher = matcher;
        this.template = template;
        this.annotations = annotations;
        this.locals = new LocalVariableNameGenerator();
        this.statements = new ArrayList<String>();
    }

    public MethodGenerator analyze(ContextSnapshot snapshot) {
        this.snapshot = snapshot;
        this.context = this.computeInitialContext(snapshot);
        this.mocked = new MockedInteractions(this.setup.newGenerator(this.context), this.matcher.newGenerator(this.context), snapshot.getSetupInput(), snapshot.getExpectOutput());
        this.resolver = new GenericsResolver(snapshot.getMethod(), snapshot.getActualArgumentTypes());
        return this;
    }

    private DefaultDeserializerContext computeInitialContext(ContextSnapshot snapshot) {
        DefaultDeserializerContext context = new DefaultDeserializerContext(this.types, this.locals);
        for (CustomAnnotation annotation : this.annotations) {
            context.addHint(annotation.getTarget(), annotation.getAnnotation());
        }
        TreeAnalyzer analyzer = new TreeAnalyzer().addListener(new ReferenceAnalyzer(context));
        analyzer.analyze(snapshot);
        return context;
    }

    public MethodGenerator generateArrange() {
        this.statements.add(BEGIN_ARRANGE);
        Deserializer deserializer = this.setup.newGenerator(this.context);
        this.types.registerType(this.snapshot.getThisType());
        this.snapshot.streamSetupGlobals().forEach(global -> this.types.registerImport(global.getDeclaringClass()));
        Computation setupThis = this.snapshot.onSetupThis().map(self -> this.prepareThis((SerializedValue)self, this.snapshot.getThisType(), deserializer)).orElseGet(() -> this.prepareStatic(this.snapshot.getThisType()));
        setupThis.getStatements().forEach(this.statements::add);
        List setupArgs = this.snapshot.streamSetupArgs().map(arg -> this.prepareArgument((SerializedArgument)arg, deserializer)).collect(Collectors.toList());
        setupArgs.stream().flatMap(arg -> arg.getStatements().stream()).forEach(this.statements::add);
        List setupGlobals = this.snapshot.streamSetupGlobals().map(global -> this.assignGlobal(global.getDeclaringClass(), global.getName(), global.getValue().accept(deserializer))).collect(Collectors.toList());
        setupGlobals.stream().flatMap(arg -> arg.getStatements().stream()).forEach(this.statements::add);
        this.base = setupThis.isStored() ? setupThis.getValue() : this.newLocal(this.snapshot.getThisType(), setupThis.getValue());
        this.args = setupArgs.stream().map(arg -> arg.getValue()).collect(Collectors.toList());
        this.statements.addAll(this.mocked.prepare(this.context));
        return this;
    }

    private Computation prepareThis(SerializedValue self, Type type, Deserializer deserializer) {
        Computation computation = self.accept(deserializer);
        if (computation.isStored()) {
            return computation;
        }
        if (this.isLiteral(type)) {
            return computation;
        }
        ArrayList<String> statements = new ArrayList<String>(computation.getStatements());
        String value = computation.getValue();
        this.types.registerType(type);
        String name = this.locals.fetchName(type);
        statements.add(Templates.assignLocalVariableStatement(this.types.getVariableTypeName(type), name, value));
        return Computation.variable(name, type, statements);
    }

    private Computation prepareStatic(Type type) {
        return Computation.variable(this.types.getVariableTypeName(this.types.wrapHidden(type)), null);
    }

    private Computation prepareArgument(SerializedArgument arg, Deserializer deserializer) {
        Type argType = arg.getType();
        SerializedValue argValue = arg.getValue();
        Type type = (Type)((Object)Types.mostSpecialOf((Type[])argValue.getUsedTypes()).orElse(Object.class));
        Computation computation = arg.accept(deserializer);
        if (!Types.assignableTypes((Type)argType, (Type)type)) {
            this.types.registerType(argType);
            argType = this.resolver.resolve(argType);
            String value = Templates.cast(this.types.getVariableTypeName(argType), computation.getValue());
            computation = Computation.expression(value, argType, computation.getStatements());
        }
        if (computation.isStored()) {
            return computation;
        }
        if (this.isLiteral(type)) {
            return computation;
        }
        ArrayList<String> statements = new ArrayList<String>(computation.getStatements());
        String value = computation.getValue();
        this.types.registerType(type);
        String name = this.locals.fetchName(type);
        statements.add(Templates.assignLocalVariableStatement(this.types.getVariableTypeName(argType), name, value));
        return Computation.variable(name, type, statements);
    }

    private Computation assignGlobal(Class<?> clazz, String name, Computation global) {
        ArrayList<String> statements = new ArrayList<String>(global.getStatements());
        String base = this.types.getVariableTypeName(clazz);
        statements.add(Templates.assignFieldStatement(base, name, global.getValue()));
        String value = Templates.fieldAccess(base, name);
        return Computation.variable(value, global.getType(), statements);
    }

    public MethodGenerator generateAct() {
        this.statements.add(BEGIN_ACT);
        Type resultType = this.snapshot.getResultType();
        String methodName = this.snapshot.getMethodName();
        MethodGenerator gen = this.snapshot.onExpectException().map(e -> new MethodGenerator(this.no, this.types, this.setup, this.matcher, this.template, this.annotations).analyze(this.snapshot)).orElse(this);
        String statement = Templates.callMethod(this.base, methodName, this.args);
        if (resultType != Void.TYPE) {
            this.result = gen.newLocal(resultType, statement, true);
        } else {
            gen.execute(statement);
        }
        this.snapshot.onExpectException().ifPresent(exception -> {
            ArrayList<String> exceptionBlock = new ArrayList<String>();
            exceptionBlock.addAll(gen.statements);
            if (resultType != Void.TYPE) {
                exceptionBlock.add(Templates.returnStatement(this.result));
            }
            this.error = this.capture(exceptionBlock, exception.getType());
        });
        return this;
    }

    public MethodGenerator generateAssert() {
        this.types.staticImport(MatcherAssert.class, "assertThat");
        this.statements.add(BEGIN_ASSERT);
        this.statements.addAll(this.mocked.verify(this.locals, this.types, this.context));
        if (this.error == null) {
            this.snapshot.streamExpectResult().flatMap(res -> this.generateResultAssert(this.types, (SerializedResult)res, this.result)).forEach(this.statements::add);
        } else {
            this.snapshot.streamExpectException().flatMap(e -> this.generateExceptionAssert(this.types, (SerializedValue)e, this.error)).forEach(this.statements::add);
        }
        boolean thisChanged = this.snapshot.onThis().map((before, after) -> this.different((SerializedValue)before, (SerializedValue)after), other -> false).orElse(true);
        this.snapshot.streamExpectThis().flatMap(self -> this.generateThisAssert(this.types, (SerializedValue)self, this.base, thisChanged)).forEach(this.statements::add);
        Object[] argsChanged = this.different(this.snapshot.getSetupArgs(), this.snapshot.getExpectArgs());
        Object[] snapshotExpectArgs = this.snapshot.getExpectArgs();
        Triple[] arguments = Triple.zip((Object[])snapshotExpectArgs, (Object[])this.args.toArray(new String[0]), (Object[])argsChanged);
        Stream.of(arguments).flatMap(arg -> this.generateArgumentAssert(this.types, (SerializedArgument)arg.getElement1(), (String)arg.getElement2(), (Boolean)arg.getElement3())).forEach(this.statements::add);
        Object[] globalsChanged = this.compare(this.snapshot.getSetupGlobals(), this.snapshot.getExpectGlobals());
        Object[] snapshotExpectGlobals = this.snapshot.getExpectGlobals();
        Pair[] globals = Pair.zip((Object[])snapshotExpectGlobals, (Object[])globalsChanged);
        Stream.of(globals).flatMap(global -> this.generateGlobalAssert(this.types, (SerializedField)global.getElement1(), (Boolean)global.getElement2())).forEach(this.statements::add);
        return this;
    }

    private Stream<String> generateResultAssert(TypeManager types, SerializedResult result, String expression) {
        Deserializer deserializer = this.matcher.newGenerator(this.context.newIsolatedContext(types, this.locals));
        Computation matcherExpression = result.accept(deserializer);
        if (matcherExpression == null) {
            return Stream.empty();
        }
        return this.createAssertion(matcherExpression, expression).stream();
    }

    private Stream<String> generateExceptionAssert(TypeManager types, SerializedValue exception, String expression) {
        Deserializer deserializer = this.matcher.newGenerator(this.context.newIsolatedContext(types, this.locals));
        Computation matcherExpression = exception.accept(deserializer);
        return this.createAssertion(matcherExpression, expression).stream();
    }

    private Stream<String> generateThisAssert(TypeManager types, SerializedValue value, String expression, boolean changed) {
        Deserializer deserializer = this.matcher.newGenerator(this.context.newIsolatedContext(types, this.locals));
        Computation matcherExpression = value.accept(deserializer);
        return this.createAssertion(matcherExpression, expression, changed).stream();
    }

    private Stream<String> generateArgumentAssert(TypeManager types, SerializedArgument arg, String expression, boolean changed) {
        Deserializer deserializer = this.matcher.newGenerator(this.context.newIsolatedContext(types, this.locals));
        if (arg == null || arg.getValue() instanceof SerializedLiteral || arg.getValue() instanceof SerializedImmutableType) {
            return Stream.empty();
        }
        Computation matcherExpression = arg.accept(deserializer);
        if (matcherExpression == null) {
            return Stream.empty();
        }
        return this.createAssertion(matcherExpression, expression, changed).stream();
    }

    private Stream<String> generateGlobalAssert(TypeManager types, SerializedField value, boolean changed) {
        Deserializer deserializer = this.matcher.newGenerator(this.context.newIsolatedContext(types, this.locals));
        Computation matcherExpression = value.getValue().accept(deserializer);
        String expression = Templates.fieldAccess(types.getVariableTypeName(value.getDeclaringClass()), value.getName());
        return this.createAssertion(matcherExpression, expression, changed).stream();
    }

    private Boolean[] compare(SerializedField[] s, SerializedField[] e) {
        Boolean[] changes = new Boolean[s.length];
        for (int i = 0; i < changes.length; ++i) {
            changes[i] = this.different(s[i].getValue(), e[i].getValue());
        }
        return changes;
    }

    private Boolean[] different(SerializedArgument[] s, SerializedArgument[] e) {
        Boolean[] changes = new Boolean[s.length];
        for (int i = 0; i < changes.length; ++i) {
            changes[i] = this.different(s[i].getValue(), e[i].getValue());
        }
        return changes;
    }

    private boolean different(SerializedValue s, SerializedValue e) {
        if (s == e) {
            return false;
        }
        if (s == null || e == null) {
            return true;
        }
        DefaultDeserializerContext context = DefaultDeserializerContext.empty();
        Deserializer deserializer = this.setup.newGenerator(context);
        context.clear();
        Computation sc = s.accept(deserializer);
        context.clear();
        Computation ec = e.accept(deserializer);
        return !ec.getValue().equals(sc.getValue()) || !ec.getStatements().equals(sc.getStatements());
    }

    private List<String> createAssertion(Computation matcher, String exp, boolean changed) {
        ArrayList<String> statements = new ArrayList<String>();
        statements.addAll(matcher.getStatements());
        if (changed) {
            statements.add(Templates.callLocalMethodStatement("assertThat", Literals.asLiteral((String)"expected change:"), exp, matcher.getValue()));
        } else {
            statements.add(Templates.callLocalMethodStatement("assertThat", Literals.asLiteral((String)"expected no change, but was:"), exp, matcher.getValue()));
        }
        return statements;
    }

    private List<String> createAssertion(Computation matcher, String exp) {
        ArrayList<String> statements = new ArrayList<String>();
        statements.addAll(matcher.getStatements());
        statements.add(Templates.callLocalMethodStatement("assertThat", exp, matcher.getValue()));
        return statements;
    }

    public String newLocal(Type type, String value) {
        return this.newLocal(type, value, false);
    }

    public String newLocal(Type type, String value, boolean force) {
        if (this.isLiteral(type) && !force) {
            return value;
        }
        this.types.registerImport(Types.baseType((Type)type));
        String name = this.locals.fetchName(type);
        this.statements.add(Templates.assignLocalVariableStatement(this.types.getVariableTypeName(type), name, value));
        return name;
    }

    public void execute(String value) {
        this.statements.add(Templates.expressionStatement(value));
    }

    public String capture(List<String> capturedStatements, Type type) {
        this.types.staticImport(Throwables.class, "capture");
        String name = this.locals.fetchName(type);
        String exceptionType = this.types.getRawClass(type);
        String capture = Templates.captureException(capturedStatements, exceptionType);
        this.statements.add(Templates.assignLocalVariableStatement(this.types.getVariableTypeName(type), name, capture));
        return name;
    }

    private boolean isLiteral(Type type) {
        return Types.isPrimitive((Type)type) || LITERAL_TYPES.contains(type);
    }

    public String generateTest() {
        return this.template.testMethod(this.testName(), this.types, this.annotations(), this.statements);
    }

    private List<String> annotations() {
        return this.snapshot.streamExpectResult().flatMap(result -> Stream.concat(this.context.getHints((SerializedRole)result, AnnotateTimestamp.class).map(annotation -> this.generateTimestampAnnotation(annotation.format())), this.context.getHints((SerializedRole)result, AnnotateGroupExpression.class).map(annotation -> this.generateGroupAnnotation(annotation.expression())))).collect(Collectors.toList());
    }

    private String generateTimestampAnnotation(String format) {
        String date = new SimpleDateFormat(format).format(new Date(this.snapshot.getTime()));
        this.types.registerImport(AnnotatedBy.class);
        return Templates.annotation(this.types.getRawTypeName((Type)((Object)AnnotatedBy.class)), Arrays.asList(new Pair((Object)"name", (Object)Literals.asLiteral((String)"timestamp")), new Pair((Object)"value", (Object)Literals.asLiteral((String)date))));
    }

    private String generateGroupAnnotation(String expression) {
        this.types.registerImport(AnnotatedBy.class);
        return this.snapshot.onSetupThis().flatMap(self -> new SerializedValueEvaluator(expression).applyTo((SerializedValue)self)).filter(value -> value instanceof SerializedLiteral).map(value -> ((SerializedLiteral)value).getValue()).map(value -> Templates.annotation(this.types.getRawTypeName((Type)((Object)AnnotatedBy.class)), Arrays.asList(new Pair((Object)"name", (Object)Literals.asLiteral((String)"group")), new Pair((Object)"value", (Object)Literals.asLiteral((String)value.toString()))))).orElse(null);
    }

    private String testName() {
        String testName = this.snapshot.getMethodName();
        return Character.toUpperCase(testName.charAt(0)) + testName.substring(1) + this.no;
    }
}

