/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.generator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.amygdalum.testrecorder.SnapshotManager;
import net.amygdalum.testrecorder.TestrecorderThreadFactory;
import net.amygdalum.testrecorder.deserializers.Adaptors;
import net.amygdalum.testrecorder.deserializers.CustomAnnotation;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerators;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerators;
import net.amygdalum.testrecorder.generator.ClassGenerator;
import net.amygdalum.testrecorder.generator.DefaultTestGeneratorProfile;
import net.amygdalum.testrecorder.generator.RenderedTest;
import net.amygdalum.testrecorder.generator.TestGeneratorProfile;
import net.amygdalum.testrecorder.generator.TestTemplate;
import net.amygdalum.testrecorder.profile.AgentConfiguration;
import net.amygdalum.testrecorder.profile.PerformanceProfile;
import net.amygdalum.testrecorder.profile.SnapshotConsumer;
import net.amygdalum.testrecorder.types.ContextSnapshot;
import net.amygdalum.testrecorder.util.ClassDescriptor;
import net.amygdalum.testrecorder.util.Logger;
import net.amygdalum.testrecorder.util.Types;

public class TestGenerator
implements SnapshotConsumer {
    private static final String RECORDED_TEST = "RecordedTest";
    private ExecutorService executor;
    private volatile CompletableFuture<Void> pipeline;
    private Map<ClassDescriptor, ClassGenerator> generators;
    private SetupGenerators setup;
    private MatcherGenerators matcher;
    private TestTemplate template;
    private List<CustomAnnotation> annotations;

    public TestGenerator(AgentConfiguration config) {
        this(config.loadConfiguration(PerformanceProfile.class, new Object[0]), config.loadOptionalConfiguration(TestGeneratorProfile.class, new Object[0]).orElseGet(DefaultTestGeneratorProfile::new), config.loadConfigurations(SetupGenerator.class, new Object[0]), config.loadConfigurations(MatcherGenerator.class, new Object[0]));
    }

    public TestGenerator(PerformanceProfile profile, TestGeneratorProfile generatorProfile, List<SetupGenerator> setup, List<MatcherGenerator> matcher) {
        this.executor = TestGenerator.initExecutor(profile);
        this.generators = Collections.synchronizedMap(new LinkedHashMap());
        this.pipeline = CompletableFuture.runAsync(() -> Logger.info((Object[])new Object[]{"starting code generation"}), this.executor);
        this.setup = new SetupGenerators(new Adaptors().load(setup));
        this.matcher = new MatcherGenerators(new Adaptors().load(matcher));
        this.template = this.initTemplate(generatorProfile.template());
        this.annotations = generatorProfile.annotations();
    }

    private TestTemplate initTemplate(Class<? extends TestTemplate> template) {
        try {
            return template.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void reload(AgentConfiguration config) {
        this.reload(config.loadConfiguration(PerformanceProfile.class, new Object[0]), config.loadOptionalConfiguration(TestGeneratorProfile.class, new Object[0]).orElseGet(DefaultTestGeneratorProfile::new), config.loadConfigurations(SetupGenerator.class, new Object[0]), config.loadConfigurations(MatcherGenerator.class, new Object[0]));
    }

    public void reload(PerformanceProfile profile, TestGeneratorProfile generatorProfile, List<SetupGenerator> setup, List<MatcherGenerator> matcher) {
        this.executor = TestGenerator.initExecutor(profile);
        this.generators = Collections.synchronizedMap(new LinkedHashMap());
        this.pipeline = this.pipeline.thenRunAsync(() -> Logger.info((Object[])new Object[]{"restarting code generation"}), this.executor);
        this.setup = new SetupGenerators(new Adaptors().load(setup));
        this.matcher = new MatcherGenerators(new Adaptors().load(matcher));
        this.template = this.initTemplate(generatorProfile.template());
        this.annotations = generatorProfile.annotations();
    }

    private static ThreadPoolExecutor initExecutor(PerformanceProfile profile) {
        return new ThreadPoolExecutor(0, 1, profile.getIdleTime(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new TestrecorderThreadFactory("$consume"));
    }

    public static TestGenerator fromRecorded() {
        SnapshotConsumer consumer = SnapshotManager.MANAGER.getMethodConsumer();
        if (!(consumer instanceof TestGenerator)) {
            return null;
        }
        TestGenerator testGenerator = (TestGenerator)consumer;
        return testGenerator.await();
    }

    @Override
    public synchronized void accept(ContextSnapshot snapshot) {
        this.pipeline = ((CompletableFuture)this.pipeline.thenRunAsync(() -> this.generatorFor(snapshot).generate(snapshot), this.executor)).exceptionally(e -> {
            Logger.error((Object[])new Object[]{"failed generating test for " + snapshot.getMethodName() + ": " + e.getClass().getSimpleName() + " " + e.getMessage(), e});
            return null;
        });
    }

    private String computePackage(ClassDescriptor clazz) {
        String pkg = clazz.getPackage();
        if (pkg.startsWith("java.lang")) {
            pkg = "test.java.lang" + pkg.substring("java.lang".length());
        }
        return pkg;
    }

    public String computeClassName(ClassDescriptor clazz) {
        return clazz.getSimpleName() + RECORDED_TEST;
    }

    public void writeResults(Path dir) {
        for (ClassDescriptor clazz : this.generators.keySet()) {
            String rendered = this.renderTest(clazz);
            try {
                Path testfile = this.locateTestFile(dir, clazz);
                Logger.info((Object[])new Object[]{"writing tests to " + testfile});
                BufferedWriter writer = Files.newBufferedWriter(testfile, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                Throwable throwable = null;
                try {
                    writer.write(rendered);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                Logger.error((Object[])new Object[]{"failed writing tests for " + rendered, e});
            }
        }
    }

    public void clearResults() {
        this.generators.clear();
        this.pipeline = CompletableFuture.runAsync(() -> Logger.info((Object[])new Object[]{"listening for snapshots"}), this.executor);
    }

    private Path locateTestFile(Path dir, ClassDescriptor clazz) throws IOException {
        String pkg = this.computePackage(clazz);
        String className = this.generatorFor(clazz).getTestName();
        Path testpackage = dir.resolve(pkg.replace('.', '/'));
        Files.createDirectories(testpackage, new FileAttribute[0]);
        return testpackage.resolve(className + ".java");
    }

    public Set<String> testsFor(Class<?> clazz) {
        return this.testsFor(ClassDescriptor.of(clazz));
    }

    public Set<String> testsFor(ClassDescriptor clazz) {
        ClassGenerator generator = this.generatorFor(clazz);
        return generator.getTests();
    }

    public ClassGenerator generatorFor(ContextSnapshot snapshot) {
        Class<?> thisType = Types.baseType((Type)snapshot.getThisType());
        while (thisType.getEnclosingClass() != null) {
            thisType = thisType.getEnclosingClass();
        }
        ClassDescriptor baseType = ClassDescriptor.of((Class)thisType);
        return this.generatorFor(baseType);
    }

    public ClassGenerator generatorFor(ClassDescriptor clazz) {
        return this.generators.computeIfAbsent(clazz, this::newGenerator);
    }

    public ClassGenerator newGenerator(ClassDescriptor clazz) {
        return new ClassGenerator(this.setup, this.matcher, this.template, this.annotations, this.computePackage(clazz), this.computeClassName(clazz));
    }

    public RenderedTest renderTest(Class<?> clazz) {
        return new RenderedTest(clazz, this.renderTest(ClassDescriptor.of(clazz)));
    }

    private String renderTest(ClassDescriptor clazz) {
        ClassGenerator generator = this.generatorFor(clazz);
        return generator.render();
    }

    public TestGenerator await() {
        this.pipeline.join();
        return this;
    }
}

