/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.profile;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.extensionpoint.ExtensionPoint;
import net.amygdalum.testrecorder.extensionpoint.ExtensionStrategy;
import net.amygdalum.testrecorder.profile.ConfigurationLoader;
import net.amygdalum.testrecorder.util.Logger;

public class AgentConfiguration {
    private List<ConfigurationLoader> configurationLoaders;
    private Map<Class<?>, Supplier<?>> defaultValues;
    private Map<Class<?>, Object> singleValues;
    private Map<Class<?>, List<?>> multiValues;

    public AgentConfiguration(ConfigurationLoader ... configurationLoaders) {
        this(Arrays.asList(configurationLoaders));
    }

    public AgentConfiguration(List<ConfigurationLoader> configurationLoaders) {
        this.configurationLoaders = configurationLoaders;
        this.defaultValues = new IdentityHashMap();
        this.singleValues = new IdentityHashMap();
        this.multiValues = new IdentityHashMap();
    }

    public List<ConfigurationLoader> getConfigurationLoaders() {
        return this.configurationLoaders;
    }

    public void setConfigurationLoaders(List<ConfigurationLoader> configurationLoaders) {
        this.configurationLoaders = configurationLoaders;
    }

    public void reset() {
        this.singleValues.clear();
        this.multiValues.clear();
    }

    public <T> AgentConfiguration withDefaultValue(Class<T> clazz, Supplier<T> defaultValue) {
        this.defaultValues.put(clazz, defaultValue);
        return this;
    }

    public <T> Optional<T> loadOptionalConfiguration(Class<T> clazz, Object ... args) {
        Object cached;
        assert (clazz.isAnnotationPresent(ExtensionPoint.class));
        assert (clazz.getAnnotation(ExtensionPoint.class).strategy() == ExtensionStrategy.OVERRIDING);
        if (args.length == 0 && (cached = this.singleValues.get(clazz)) != null) {
            return Optional.of(clazz.cast(cached));
        }
        Optional<T> config = this.load(clazz, args).findFirst();
        if (args.length == 0 && config.isPresent()) {
            this.singleValues.put(clazz, config.get());
        }
        return config;
    }

    public <T> T loadConfiguration(Class<T> clazz, Object ... args) {
        Object cached;
        assert (clazz.isAnnotationPresent(ExtensionPoint.class));
        assert (clazz.getAnnotation(ExtensionPoint.class).strategy() == ExtensionStrategy.OVERRIDING);
        if (args.length == 0 && (cached = this.singleValues.get(clazz)) != null) {
            return clazz.cast(cached);
        }
        Optional<Object> matchingConfig = this.load(clazz, args).findFirst();
        Object config = matchingConfig.orElseGet(() -> this.loadDefault(clazz));
        if (args.length == 0) {
            this.singleValues.put(clazz, config);
        }
        return (T)config;
    }

    protected <T> T loadDefault(Class<T> clazz) {
        Supplier<?> defaultConfigSupplier = this.defaultValues.get(clazz);
        if (defaultConfigSupplier == null) {
            return null;
        }
        T defaultConfig = clazz.cast(defaultConfigSupplier.get());
        this.logLoad("default", defaultConfig);
        return defaultConfig;
    }

    public <T> List<T> loadConfigurations(Class<T> clazz, Object ... args) {
        List<?> cached;
        assert (clazz.isAnnotationPresent(ExtensionPoint.class));
        assert (clazz.getAnnotation(ExtensionPoint.class).strategy() == ExtensionStrategy.EXTENDING);
        if (args.length == 0 && (cached = this.multiValues.get(clazz)) != null) {
            return cached;
        }
        List configs = this.load(clazz, args).collect(Collectors.toList());
        if (args.length == 0) {
            this.multiValues.put(clazz, configs);
        }
        return configs;
    }

    protected <T> Stream<T> load(Class<T> clazz, Object ... args) {
        Stream.Builder configurations = Stream.builder();
        for (ConfigurationLoader configurationLoader : this.configurationLoaders) {
            configurationLoader.load(clazz, args).forEach(configurations::add);
        }
        return configurations.build().distinct();
    }

    private <T> T logLoad(String prefix, T object) {
        if (object != null) {
            Logger.info((Object[])new Object[]{"loading " + prefix + " " + object.getClass().getSimpleName()});
        }
        return object;
    }
}

