/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.profile;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.profile.AbstractPathConfigurationLoader;
import net.amygdalum.testrecorder.profile.ConfigurationLoader;
import net.amygdalum.testrecorder.util.Logger;

public class ClassPathConfigurationLoader
extends AbstractPathConfigurationLoader
implements ConfigurationLoader {
    public ClassPathConfigurationLoader() {
        this(ConfigurationLoader.defaultClassLoader(ClassPathConfigurationLoader.class));
    }

    public ClassPathConfigurationLoader(ClassLoader loader) {
        super(loader);
    }

    @Override
    public <T> Stream<T> load(Class<T> clazz, Object ... args) {
        Stream.Builder configurations = Stream.builder();
        try {
            Enumeration<URL> urls = this.loader.getResources("agentconfig/" + clazz.getName());
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                Path lookupPath = this.pathFrom(url);
                try {
                    this.configsFrom(lookupPath, clazz, args).map(this::logLoad).forEach(configurations::add);
                }
                catch (FileNotFoundException | NoSuchFileException e) {
                    Logger.debug((Object[])new Object[]{"did not find configuration file " + lookupPath + ", skipping"});
                }
                catch (IOException e) {
                    Logger.error((Object[])new Object[]{"cannot load configuration file: " + lookupPath});
                }
            }
        }
        catch (IOException e) {
            Logger.error((Object[])new Object[]{"cannot load configuration from classpath", e});
        }
        return configurations.build();
    }
}

