/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.profile;

import java.util.regex.Pattern;
import net.amygdalum.testrecorder.profile.Classes;
import org.objectweb.asm.Type;

public class ClassesByName
implements Classes {
    private static final Pattern NAME = Pattern.compile("[\\w$.]+");
    private String name;

    public ClassesByName(String name) {
        if (!NAME.matcher(name).matches()) {
            throw new IllegalArgumentException("class name should contain only word characters, dot and $, but was: " + name);
        }
        this.name = name;
    }

    @Override
    public boolean matches(Class<?> type) {
        return type.getName().equals(this.name) || type.getSimpleName().equals(this.name);
    }

    @Override
    public boolean matches(String className) {
        String refName = Type.getObjectType((String)className).getClassName();
        int lastDot = refName.lastIndexOf(46);
        String simpleName = refName.substring(lastDot + 1);
        return refName.equals(this.name) || simpleName.equals(this.name);
    }
}

