/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.profile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.amygdalum.testrecorder.profile.Classes;
import net.amygdalum.testrecorder.profile.Fields;
import net.amygdalum.testrecorder.profile.Methods;
import net.amygdalum.testrecorder.profile.SerializationProfile;

public class ConfigurableSerializationProfile
implements SerializationProfile {
    private List<Fields> fieldExclusions;
    private List<Fields> fieldFacades;
    private List<Classes> classExclusions;
    private List<Classes> classFacades;
    private List<Fields> globalFields;
    private List<Methods> inputs;
    private List<Methods> outputs;
    private List<Methods> recorded;
    private List<Classes> classes;

    public ConfigurableSerializationProfile() {
        this.fieldExclusions = new ArrayList<Fields>();
        this.fieldFacades = new ArrayList<Fields>();
        this.classExclusions = new ArrayList<Classes>();
        this.classFacades = new ArrayList<Classes>();
        this.globalFields = new ArrayList<Fields>();
        this.inputs = new ArrayList<Methods>();
        this.outputs = new ArrayList<Methods>();
        this.recorded = new ArrayList<Methods>();
        this.classes = new ArrayList<Classes>();
    }

    public ConfigurableSerializationProfile(SerializationProfile base) {
        this.fieldExclusions = new ArrayList<Fields>(base.getFieldExclusions());
        this.fieldFacades = new ArrayList<Fields>(base.getFieldFacades());
        this.classExclusions = new ArrayList<Classes>(base.getClassExclusions());
        this.classFacades = new ArrayList<Classes>(base.getClassFacades());
        this.globalFields = new ArrayList<Fields>(base.getGlobalFields());
        this.inputs = new ArrayList<Methods>(base.getInputs());
        this.outputs = new ArrayList<Methods>(base.getOutputs());
        this.recorded = new ArrayList<Methods>(base.getRecorded());
        this.classes = new ArrayList<Classes>(base.getClasses());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SerializationProfile base) {
        return new Builder(base);
    }

    @Override
    public List<Classes> getClasses() {
        return this.classes;
    }

    @Override
    public List<Fields> getFieldExclusions() {
        return this.fieldExclusions;
    }

    @Override
    public List<Fields> getFieldFacades() {
        return this.fieldFacades;
    }

    @Override
    public List<Classes> getClassExclusions() {
        return this.classExclusions;
    }

    @Override
    public List<Classes> getClassFacades() {
        return this.classFacades;
    }

    @Override
    public List<Fields> getGlobalFields() {
        return this.globalFields;
    }

    @Override
    public List<Methods> getInputs() {
        return this.inputs;
    }

    @Override
    public List<Methods> getOutputs() {
        return this.outputs;
    }

    @Override
    public List<Methods> getRecorded() {
        return this.recorded;
    }

    public static class Builder {
        private ConfigurableSerializationProfile profile;

        public Builder() {
            this.profile = new ConfigurableSerializationProfile();
        }

        public Builder(SerializationProfile base) {
            this.profile = new ConfigurableSerializationProfile(base);
        }

        public Builder withClasses(Classes ... classes) {
            return this.withClasses(Arrays.asList(classes));
        }

        public Builder withClasses(List<Classes> classes) {
            this.profile.classes.addAll(classes);
            return this;
        }

        public Builder withRecorded(Methods ... methods) {
            return this.withRecorded(Arrays.asList(methods));
        }

        public Builder withRecorded(List<Methods> methods) {
            this.profile.recorded.addAll(methods);
            return this;
        }

        public Builder withFieldExclusions(Fields ... fieldExclusions) {
            return this.withFieldExclusions(Arrays.asList(fieldExclusions));
        }

        public Builder withFieldExclusions(List<Fields> fieldExclusions) {
            this.profile.fieldExclusions.addAll(fieldExclusions);
            return this;
        }

        public Builder withFieldFacades(Fields ... fieldFacades) {
            return this.withFieldFacades(Arrays.asList(fieldFacades));
        }

        public Builder withFieldFacades(List<Fields> fieldFacades) {
            this.profile.fieldFacades.addAll(fieldFacades);
            return this;
        }

        public Builder withClassExclusions(Classes ... classExclusions) {
            return this.withClassExclusions(Arrays.asList(classExclusions));
        }

        public Builder withClassExclusions(List<Classes> classExclusions) {
            this.profile.classExclusions.addAll(classExclusions);
            return this;
        }

        public Builder withClassFacades(Classes ... classFacades) {
            return this.withClassFacades(Arrays.asList(classFacades));
        }

        public Builder withClassFacades(List<Classes> classFacades) {
            this.profile.classFacades.addAll(classFacades);
            return this;
        }

        public Builder withGlobalFields(Fields ... globalFields) {
            return this.withGlobalFields(Arrays.asList(globalFields));
        }

        public Builder withGlobalFields(List<Fields> globalFields) {
            this.profile.globalFields.addAll(globalFields);
            return this;
        }

        public Builder withInputs(Methods ... inputs) {
            return this.withInputs(Arrays.asList(inputs));
        }

        public Builder withInputs(List<Methods> inputs) {
            this.profile.inputs.addAll(inputs);
            return this;
        }

        public Builder withOutputs(Methods ... outputs) {
            return this.withOutputs(Arrays.asList(outputs));
        }

        public Builder withOutputs(List<Methods> outputs) {
            this.profile.outputs.addAll(outputs);
            return this;
        }

        public ConfigurableSerializationProfile build() {
            return this.profile;
        }
    }
}

