/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.profile;

import java.lang.reflect.Constructor;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.util.Types;

public interface ConfigurationLoader {
    public <T> Stream<T> load(Class<T> var1, Object ... var2);

    public static ClassLoader defaultClassLoader(Class<?> clazz) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = clazz.getClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    default public boolean matches(Constructor<?> constructor, Object[] args) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (args[i] == null || Types.boxedType(parameterTypes[i]).isInstance(args[i])) continue;
            return false;
        }
        return true;
    }
}

