/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.profile;

import java.lang.reflect.Field;
import java.util.regex.Pattern;
import net.amygdalum.testrecorder.profile.Fields;
import org.objectweb.asm.Type;

public class FieldsByName
implements Fields {
    private static final Pattern NAME = Pattern.compile("[\\w$.]+");
    private String clazz;
    private String name;

    public FieldsByName(String name) {
        if (!NAME.matcher(name).matches()) {
            throw new IllegalArgumentException("field name should contain only word characters, dot and $, but was: " + name);
        }
        int lastDot = name.lastIndexOf(46);
        if (lastDot > -1) {
            this.clazz = name.substring(0, lastDot);
            this.name = name.substring(lastDot + 1);
        } else {
            this.name = name;
        }
    }

    @Override
    public boolean matches(Field field) {
        if (this.clazz == null) {
            return field.getName().equals(this.name);
        }
        return field.getName().equals(this.name) && field.getDeclaringClass().getName().equals(this.clazz);
    }

    @Override
    public boolean matches(String className, String fieldName, String fieldDescriptor) {
        if (this.clazz == null) {
            return fieldName.equals(this.name);
        }
        String refName = Type.getObjectType((String)className).getClassName();
        return fieldName.equals(this.name) && refName.equals(this.clazz);
    }
}

