/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.profile;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import net.amygdalum.testrecorder.profile.Methods;
import org.objectweb.asm.Type;

public class MethodsByName
implements Methods {
    private static final Pattern NAME = Pattern.compile("[\\w$.]+");
    private String clazz;
    private String name;

    public MethodsByName(String name) {
        if (!NAME.matcher(name).matches()) {
            throw new IllegalArgumentException("method name should contain only word characters, dot and $, but was: " + name);
        }
        int lastDot = name.lastIndexOf(46);
        if (lastDot > -1) {
            this.clazz = name.substring(0, lastDot);
            this.name = name.substring(lastDot + 1);
        } else {
            this.name = name;
        }
    }

    @Override
    public boolean matches(Method method) {
        if (this.clazz == null) {
            return method.getName().equals(this.name);
        }
        return method.getName().equals(this.name) && method.getDeclaringClass().getName().equals(this.clazz);
    }

    @Override
    public boolean matches(String className, String methodName, String methodDescriptor) {
        if (this.clazz == null) {
            return methodName.equals(this.name);
        }
        String refName = Type.getObjectType((String)className).getClassName();
        return methodName.equals(this.name) && refName.equals(this.clazz);
    }
}

