/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.profile;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.profile.AbstractPathConfigurationLoader;
import net.amygdalum.testrecorder.profile.ConfigurationLoader;
import net.amygdalum.testrecorder.util.Logger;

public class PathConfigurationLoader
extends AbstractPathConfigurationLoader
implements ConfigurationLoader {
    private List<Path> configurationPaths;

    public PathConfigurationLoader(Path ... configurationPaths) {
        this(ConfigurationLoader.defaultClassLoader(PathConfigurationLoader.class), Arrays.asList(configurationPaths));
    }

    public PathConfigurationLoader(List<Path> configurationPaths) {
        this(ConfigurationLoader.defaultClassLoader(PathConfigurationLoader.class), configurationPaths);
    }

    public PathConfigurationLoader(ClassLoader loader, Path ... configurationPaths) {
        this(loader, Arrays.asList(configurationPaths));
    }

    public PathConfigurationLoader(ClassLoader loader, List<Path> configurationPaths) {
        super(loader);
        this.configurationPaths = configurationPaths;
    }

    @Override
    public <T> Stream<T> load(Class<T> clazz, Object ... args) {
        Stream.Builder configurations = Stream.builder();
        for (Path configurationPath : this.configurationPaths) {
            Path lookupPath = configurationPath.resolve(clazz.getName());
            try {
                this.configsFrom(lookupPath, clazz, args).map(this::logLoad).forEach(configurations::add);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                Logger.debug((Object[])new Object[]{"did not find configuration file " + lookupPath + ", skipping"});
            }
            catch (IOException e) {
                Logger.error((Object[])new Object[]{"cannot load configuration file: " + lookupPath});
            }
        }
        return configurations.build();
    }
}

