/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import net.amygdalum.testrecorder.types.FieldSignature;
import net.amygdalum.testrecorder.types.SerializationException;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.SerializerSession;
import net.amygdalum.testrecorder.util.Reflections;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedNull;

public abstract class AbstractCompositeSerializer {
    public SerializedField resolvedFieldOf(SerializerSession session, Object object, Class<?> type, String name) {
        try {
            Field field = type.getDeclaredField(name);
            return this.resolvedFieldOf(session, object, field);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new SerializationException(e);
        }
    }

    public SerializedField resolvedFieldOf(SerializerSession session, Object object, Field field) {
        Class<?> declaringClass = field.getDeclaringClass();
        String name = field.getName();
        Type type = Types.serializableOf((Type)field.getGenericType());
        FieldSignature signature = new FieldSignature(declaringClass, type, name);
        Object value = this.fieldOf(object, field);
        SerializedValue serializedValue = this.resolvedValueOf(session, type, value);
        return new SerializedField(signature, serializedValue);
    }

    public SerializedValue resolvedValueOf(SerializerSession session, Type type, Object value) {
        Class clazz;
        SerializedValue serializedValue = session.ref(value, type);
        if (serializedValue != null) {
            return serializedValue;
        }
        Class clazz2 = clazz = type == null ? null : Types.baseType((Type)type);
        if (value == null) {
            SerializedNull nullInstance = SerializedNull.nullInstance();
            if (clazz != null && !clazz.isSynthetic()) {
                nullInstance.useAs(type);
            }
            return nullInstance;
        }
        if (Types.isPrimitive((Type)clazz)) {
            return SerializedLiteral.literal(clazz, value);
        }
        if (Types.isLiteral(value.getClass())) {
            return SerializedLiteral.literal(value);
        }
        throw new SerializationException("cannot resolve value of type " + value.getClass().getName());
    }

    public Object fieldOf(Object object, Class<?> type, String name) {
        try {
            Field field = type.getDeclaredField(name);
            return this.fieldOf(object, field);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new SerializationException(e);
        }
    }

    public Object fieldOf(Object object, Field field) {
        try {
            return Reflections.accessing((AccessibleObject)field).call(f -> f.get(object));
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new SerializationException(e);
        }
    }
}

