/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.serializers.AbstractCompositeSerializer;
import net.amygdalum.testrecorder.types.Serializer;
import net.amygdalum.testrecorder.types.SerializerSession;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedArray;

public class ArraySerializer
extends AbstractCompositeSerializer
implements Serializer<SerializedArray> {
    @Override
    public Stream<?> components(Object object, SerializerSession session) {
        Class<?> type = object.getClass().getComponentType();
        if (Types.isPrimitive(type)) {
            return Stream.empty();
        }
        Stream.Builder<Object> components = Stream.builder();
        for (int i = 0; i < Array.getLength(object); ++i) {
            Object component = Array.get(object, i);
            components.add(component);
        }
        return components.build();
    }

    @Override
    public List<Class<?>> getMatchingClasses() {
        return Collections.emptyList();
    }

    @Override
    public SerializedArray generate(Class<?> type, SerializerSession session) {
        return new SerializedArray(type);
    }

    @Override
    public void populate(SerializedArray serializedObject, Object object, SerializerSession session) {
        Class<?> type = object.getClass().getComponentType();
        for (int i = 0; i < Array.getLength(object); ++i) {
            Object component = Array.get(object, i);
            serializedObject.add(this.resolvedValueOf(session, type, component));
        }
    }
}

