/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.serializers.HiddenInnerClassSerializer;
import net.amygdalum.testrecorder.types.SerializerSession;
import net.amygdalum.testrecorder.util.TypeFilters;
import net.amygdalum.testrecorder.values.SerializedList;

public class ArraysListSerializer
extends HiddenInnerClassSerializer<SerializedList> {
    public ArraysListSerializer() {
        super(Arrays.class);
    }

    @Override
    public List<Class<?>> getMatchingClasses() {
        return this.innerClasses().stream().filter(TypeFilters.in((String[])new String[]{"ArrayList"})).filter(clazz -> List.class.isAssignableFrom((Class<?>)clazz)).collect(Collectors.toList());
    }

    @Override
    public Stream<?> components(Object object, SerializerSession session) {
        return ((List)object).stream();
    }

    @Override
    public SerializedList generate(Class<?> type, SerializerSession session) {
        return new SerializedList(type);
    }

    @Override
    public void populate(SerializedList serializedObject, Object object, SerializerSession session) {
        for (Object element : (List)object) {
            serializedObject.add(this.resolvedValueOf(session, serializedObject.getComponentType(), element));
        }
    }
}

