/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.serializers.HiddenInnerClassSerializer;
import net.amygdalum.testrecorder.types.SerializerSession;
import net.amygdalum.testrecorder.util.Reflections;
import net.amygdalum.testrecorder.util.TypeFilters;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedList;

public class CollectionsListSerializer
extends HiddenInnerClassSerializer<SerializedList> {
    public CollectionsListSerializer() {
        super(Collections.class);
    }

    @Override
    public List<Class<?>> getMatchingClasses() {
        return this.innerClasses().stream().filter(TypeFilters.startingWith((String[])new String[]{"Unmodifiable", "Synchronized", "Checked", "Empty", "Singleton"})).filter(clazz -> List.class.isAssignableFrom((Class<?>)clazz)).collect(Collectors.toList());
    }

    @Override
    public Stream<?> components(Object object, SerializerSession session) {
        return ((List)object).stream();
    }

    @Override
    public SerializedList generate(Class<?> type, SerializerSession session) {
        return new SerializedList(type);
    }

    @Override
    public void populate(SerializedList serializedObject, Object object, SerializerSession session) {
        Type componentType = this.computeComponentType(serializedObject, object);
        for (Object element : (List)object) {
            serializedObject.add(this.resolvedValueOf(session, componentType, element));
        }
        serializedObject.useAs((Type)Types.parameterized(List.class, null, (Type[])new Type[]{componentType}));
    }

    private Type computeComponentType(SerializedList serializedObject, Object object) {
        if (object.getClass().getSimpleName().contains("Checked")) {
            return this.getTypeField(object);
        }
        Stream<Type> definedTypes = Arrays.stream(serializedObject.getUsedTypes()).map(type -> (Type)((Object)Types.typeArgument((Type)type, (int)0).orElse(Object.class)));
        Stream<Type> elementTypes = ((List)object).stream().filter(Objects::nonNull).map(element -> element.getClass());
        Stream<Type> usedTypes = Stream.concat(definedTypes, elementTypes);
        return Types.inferType((Type[])((Type[])usedTypes.toArray(Type[]::new)));
    }

    private Class<?> getTypeField(Object object) {
        try {
            return (Class)Reflections.getValue((String)"type", (Object)object);
        }
        catch (ReflectiveOperationException e) {
            return Object.class;
        }
    }
}

