/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.serializers.HiddenInnerClassSerializer;
import net.amygdalum.testrecorder.types.SerializerSession;
import net.amygdalum.testrecorder.util.Reflections;
import net.amygdalum.testrecorder.util.SerializableParameterizedType;
import net.amygdalum.testrecorder.util.TypeFilters;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedMap;

public class CollectionsMapSerializer
extends HiddenInnerClassSerializer<SerializedMap> {
    public CollectionsMapSerializer() {
        super(Collections.class);
    }

    @Override
    public List<Class<?>> getMatchingClasses() {
        return this.innerClasses().stream().filter(TypeFilters.startingWith((String[])new String[]{"Unmodifiable", "Synchronized", "Checked", "Empty", "Singleton"})).filter(clazz -> Map.class.isAssignableFrom((Class<?>)clazz)).collect(Collectors.toList());
    }

    @Override
    public Stream<?> components(Object object, SerializerSession session) {
        return ((Map)object).entrySet().stream().flatMap(entry -> Stream.of(entry.getKey(), entry.getValue()));
    }

    @Override
    public SerializedMap generate(Class<?> type, SerializerSession session) {
        return new SerializedMap(type);
    }

    @Override
    public void populate(SerializedMap serializedObject, Object object, SerializerSession session) {
        Type[] componentTypes = this.computeComponentType(serializedObject, object);
        Type keyType = componentTypes[0];
        Type valueType = componentTypes[1];
        for (Map.Entry element : ((Map)object).entrySet()) {
            Object key = element.getKey();
            Object value = element.getValue();
            serializedObject.put(this.resolvedValueOf(session, keyType, key), this.resolvedValueOf(session, valueType, value));
        }
        SerializableParameterizedType newType = Types.parameterized(Map.class, null, (Type[])componentTypes);
        serializedObject.useAs((Type)newType);
    }

    private Type[] computeComponentType(SerializedMap serializedObject, Object object) {
        if (object.getClass().getSimpleName().contains("Checked")) {
            return new Type[]{this.getKeyTypeField(object), this.getValueTypeField(object)};
        }
        Stream<Type> keyDefinedTypes = Arrays.stream(serializedObject.getUsedTypes()).map(type -> (Type)((Object)Types.typeArgument((Type)type, (int)0).orElse(Object.class)));
        Stream<Type> keyElementTypes = ((Map)object).keySet().stream().filter(Objects::nonNull).map(element -> element.getClass());
        Stream<Type> keyTypes = Stream.concat(keyDefinedTypes, keyElementTypes);
        Stream<Type> valueDefinedTypes = Arrays.stream(serializedObject.getUsedTypes()).map(type -> (Type)((Object)Types.typeArgument((Type)type, (int)1).orElse(Object.class)));
        Stream<Type> valueElementTypes = ((Map)object).values().stream().filter(Objects::nonNull).map(element -> element.getClass());
        Stream<Type> valueTypes = Stream.concat(valueDefinedTypes, valueElementTypes);
        return new Type[]{Types.inferType((Type[])((Type[])keyTypes.toArray(Type[]::new))), Types.inferType((Type[])((Type[])valueTypes.toArray(Type[]::new)))};
    }

    private Class<?> getKeyTypeField(Object object) {
        try {
            return (Class)Reflections.getValue((String)"keyType", (Object)object);
        }
        catch (ReflectiveOperationException e) {
            return Object.class;
        }
    }

    private Class<?> getValueTypeField(Object object) {
        try {
            return (Class)Reflections.getValue((String)"valueType", (Object)object);
        }
        catch (ReflectiveOperationException e) {
            return Object.class;
        }
    }
}

