/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.serializers.HiddenInnerClassSerializer;
import net.amygdalum.testrecorder.types.SerializerSession;
import net.amygdalum.testrecorder.util.Reflections;
import net.amygdalum.testrecorder.util.TypeFilters;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedSet;

public class CollectionsSetSerializer
extends HiddenInnerClassSerializer<SerializedSet> {
    public CollectionsSetSerializer() {
        super(Collections.class);
    }

    @Override
    public List<Class<?>> getMatchingClasses() {
        return this.innerClasses().stream().filter(TypeFilters.startingWith((String[])new String[]{"Unmodifiable", "Synchronized", "Checked", "Empty", "Singleton"})).filter(clazz -> Set.class.isAssignableFrom((Class<?>)clazz)).collect(Collectors.toList());
    }

    @Override
    public Stream<?> components(Object object, SerializerSession session) {
        return ((Set)object).stream();
    }

    @Override
    public SerializedSet generate(Class<?> type, SerializerSession session) {
        return new SerializedSet(type);
    }

    @Override
    public void populate(SerializedSet serializedObject, Object object, SerializerSession session) {
        Type componentType = this.computeComponentType(serializedObject, object);
        for (Object element : (Set)object) {
            serializedObject.add(this.resolvedValueOf(session, componentType, element));
        }
        serializedObject.useAs((Type)Types.parameterized(Set.class, null, (Type[])new Type[]{componentType}));
    }

    private Type computeComponentType(SerializedSet serializedObject, Object object) {
        if (object.getClass().getSimpleName().contains("Checked")) {
            return this.getTypeField(object);
        }
        Stream<Type> definedTypes = Arrays.stream(serializedObject.getUsedTypes()).map(type -> (Type)((Object)Types.typeArgument((Type)type, (int)0).orElse(Object.class)));
        Stream<Type> elementTypes = ((Set)object).stream().filter(Objects::nonNull).map(element -> element.getClass());
        Stream<Type> usedTypes = Stream.concat(definedTypes, elementTypes);
        return Types.inferType((Type[])((Type[])usedTypes.toArray(Type[]::new)));
    }

    private Class<?> getTypeField(Object object) {
        try {
            return (Class)Reflections.getValue((String)"type", (Object)object);
        }
        catch (ReflectiveOperationException e) {
            return Object.class;
        }
    }
}

