/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.serializers.AbstractCompositeSerializer;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.Serializer;
import net.amygdalum.testrecorder.types.SerializerSession;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedNull;
import net.amygdalum.testrecorder.values.SerializedObject;

public class GenericSerializer
extends AbstractCompositeSerializer
implements Serializer<SerializedReferenceType> {
    @Override
    public List<Class<?>> getMatchingClasses() {
        return Collections.emptyList();
    }

    @Override
    public Stream<?> components(Object object, SerializerSession session) {
        Stream.Builder<Object> components = Stream.builder();
        if (!session.facades(object)) {
            for (Class<?> objectClass = object.getClass(); objectClass != Object.class && !session.excludes(objectClass); objectClass = objectClass.getSuperclass()) {
                for (Field f : objectClass.getDeclaredFields()) {
                    if (session.excludes(f) || session.facades(f) || Types.isPrimitive(f.getType())) continue;
                    components.add(this.fieldOf(object, f));
                }
            }
        }
        return components.build();
    }

    @Override
    public SerializedReferenceType generate(Class<?> type, SerializerSession session) {
        if (session.excludes(Types.baseType(type))) {
            return SerializedNull.nullInstance();
        }
        return new SerializedObject(type);
    }

    @Override
    public void populate(SerializedReferenceType serializedValue, Object object, SerializerSession session) {
        if (!(serializedValue instanceof SerializedObject) || session.facades(object)) {
            return;
        }
        SerializedObject serializedObject = (SerializedObject)serializedValue;
        for (Class<?> objectClass = object.getClass(); objectClass != Object.class && !session.excludes(objectClass); objectClass = objectClass.getSuperclass()) {
            for (Field f : objectClass.getDeclaredFields()) {
                if (session.excludes(f)) continue;
                serializedObject.addField(this.resolvedFieldOf(session, object, f));
            }
        }
    }
}

