/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.serializers.AbstractCompositeSerializer;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.Serializer;
import net.amygdalum.testrecorder.types.SerializerSession;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedImmutable;
import net.amygdalum.testrecorder.values.SerializedObject;
import net.amygdalum.testrecorder.values.SerializedProxy;

public class ProxySerializer
extends AbstractCompositeSerializer
implements Serializer<SerializedProxy> {
    @Override
    public List<Class<?>> getMatchingClasses() {
        return Collections.emptyList();
    }

    @Override
    public Stream<?> components(Object object, SerializerSession session) {
        Stream.Builder<Object> components = Stream.builder();
        if (!session.facades(object)) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
            components.add(invocationHandler);
            for (Class<?> objectClass = object.getClass(); objectClass != Proxy.class && objectClass != Object.class && !session.excludes(objectClass); objectClass = objectClass.getSuperclass()) {
                for (Field f : objectClass.getDeclaredFields()) {
                    if (session.excludes(f) || session.facades(f) || Types.isPrimitive(f.getType())) continue;
                    components.add(this.fieldOf(object, f));
                }
            }
        }
        return components.build();
    }

    @Override
    public SerializedProxy generate(Class<?> type, SerializerSession session) {
        return new SerializedProxy((Type)type);
    }

    @Override
    public void populate(SerializedProxy serializedProxy, Object object, SerializerSession session) {
        Class<?>[] interfaces = object.getClass().getInterfaces();
        List<SerializedImmutable<Class<?>>> serializedInterfaces = Arrays.stream(interfaces).map(interfaceClass -> new SerializedImmutable<Class>(Class.class).withValue((Class)interfaceClass)).collect(Collectors.toList());
        serializedProxy.setInterfaces(serializedInterfaces);
        if (session.facades(object)) {
            SerializedObject serializedInvocationHandler = new SerializedObject(InvocationHandler.class);
            serializedProxy.setInvocationHandler(serializedInvocationHandler);
            return;
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
        SerializedValue serializedInvocationHandler = this.resolvedValueOf(session, (Type)((Object)InvocationHandler.class), invocationHandler);
        serializedProxy.setInvocationHandler(serializedInvocationHandler);
        for (Class<?> objectClass = object.getClass(); objectClass != Proxy.class && objectClass != Object.class && !session.excludes(objectClass); objectClass = objectClass.getSuperclass()) {
            for (Field f : objectClass.getDeclaredFields()) {
                if (session.excludes(f)) continue;
                serializedProxy.addField(this.resolvedFieldOf(session, object, f));
            }
        }
    }
}

