/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.types;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.amygdalum.testrecorder.types.MethodSignature;
import net.amygdalum.testrecorder.types.SerializedArgument;
import net.amygdalum.testrecorder.types.SerializedInteraction;
import net.amygdalum.testrecorder.types.SerializedResult;
import net.amygdalum.testrecorder.types.SerializedValue;

public abstract class AbstractSerializedInteraction
implements SerializedInteraction,
Serializable {
    protected int id;
    protected MethodSignature signature;
    protected SerializedResult result;
    protected SerializedArgument[] arguments;

    public AbstractSerializedInteraction(int id, MethodSignature signature) {
        this.id = id;
        this.signature = signature;
        this.arguments = new SerializedArgument[0];
    }

    public int id() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean isStatic() {
        return this.id == 0;
    }

    @Override
    public boolean isComplete() {
        if (this.result == null) {
            return false;
        }
        return this.arguments != null && this.arguments.length == this.signature.argumentTypes.length;
    }

    @Override
    public boolean hasResult() {
        return this.signature.resultType != null && this.signature.resultType != Void.TYPE && this.result != null;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.signature.declaringClass;
    }

    @Override
    public String getMethodName() {
        return this.signature.methodName;
    }

    @Override
    public Type getResultType() {
        return this.signature.resultType;
    }

    @Override
    public Type[] getArgumentTypes() {
        return this.signature.argumentTypes;
    }

    @Override
    public SerializedResult getResult() {
        return this.result;
    }

    @Override
    public SerializedArgument[] getArguments() {
        return this.arguments;
    }

    @Override
    public List<SerializedValue> getAllValues() {
        ArrayList<SerializedValue> allValues = new ArrayList<SerializedValue>();
        if (this.result != null) {
            allValues.add(this.result.getValue());
        }
        for (SerializedArgument argument : this.arguments) {
            allValues.add(argument.getValue());
        }
        return allValues;
    }

    public int hashCode() {
        return this.signature.hashCode() * 11 + (this.result == null ? 0 : this.result.hashCode() * 13) + Arrays.hashCode(this.arguments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSerializedInteraction that = (AbstractSerializedInteraction)obj;
        return this.id == that.id && this.signature.equals(that.signature) && Objects.equals(this.result, that.result) && Arrays.equals(this.arguments, that.arguments);
    }

    protected SerializedArgument[] argumentsOf(SerializedValue[] argumentValues) {
        if (argumentValues == null) {
            return new SerializedArgument[0];
        }
        SerializedArgument[] arguments = new SerializedArgument[argumentValues.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = new SerializedArgument(i, this.signature, argumentValues[i]);
        }
        return arguments;
    }

    protected SerializedResult resultOf(SerializedValue resultValue) {
        if (resultValue == null) {
            return null;
        }
        return new SerializedResult(this.signature, resultValue);
    }
}

