/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.types;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Computation {
    public static final Computation NULL = new Computation("", null, false, new ArrayList<String>());
    private List<String> statements;
    private String value;
    private Type type;
    private boolean stored;

    public Computation(String value, Type type, boolean stored, List<String> statements) {
        this.value = value;
        this.type = type;
        this.stored = stored;
        this.statements = statements;
    }

    public static Computation expression(String value, Type type) {
        return new Computation(value, type, false, new ArrayList<String>());
    }

    public static Computation expression(String value, Type type, List<String> statements) {
        return new Computation(value, type, false, statements);
    }

    public static Computation variable(String value, Type type) {
        return new Computation(value, type, true, new ArrayList<String>());
    }

    public static Computation variable(String value, Type type, List<String> statements) {
        return new Computation(value, type, true, statements);
    }

    public String getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isStored() {
        return this.stored;
    }

    public List<String> getStatements() {
        return this.statements;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.statements.isEmpty()) {
            buffer.append(this.statements.stream().collect(Collectors.joining("\n")));
            buffer.append('\n');
        }
        buffer.append(this.value).append(":").append(this.type == null ? "?" : this.type.getTypeName());
        return buffer.toString();
    }
}

