/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.types;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.types.SerializedArgument;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedInput;
import net.amygdalum.testrecorder.types.SerializedOutput;
import net.amygdalum.testrecorder.types.SerializedResult;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.VirtualMethodSignature;
import net.amygdalum.testrecorder.util.BiOptional;

public class ContextSnapshot
implements Serializable {
    public static final ContextSnapshot INVALID = new ContextSnapshot();
    private long time;
    private String key;
    private VirtualMethodSignature signature;
    private boolean valid;
    private SerializedValue setupThis;
    private SerializedArgument[] setupArgs;
    private SerializedField[] setupGlobals;
    private SerializedValue expectThis;
    private SerializedResult expectResult;
    private SerializedValue expectException;
    private SerializedArgument[] expectArgs;
    private SerializedField[] expectGlobals;
    private Deque<SerializedInput> setupInput;
    private Deque<SerializedOutput> expectOutput;

    private ContextSnapshot() {
        this.valid = false;
        this.setupInput = new ArrayDeque<SerializedInput>();
        this.expectOutput = new ArrayDeque<SerializedOutput>();
    }

    public ContextSnapshot(long time, String key, VirtualMethodSignature signature) {
        this.time = time;
        this.key = key;
        this.signature = signature;
        this.valid = true;
        this.setupInput = new ArrayDeque<SerializedInput>();
        this.expectOutput = new ArrayDeque<SerializedOutput>();
    }

    public ClassLoader getClassLoader() {
        return this.signature.getClassLoader();
    }

    public String getKey() {
        return this.key;
    }

    public boolean matches(String signature) {
        return this.key.equals(signature);
    }

    public long getTime() {
        return this.time;
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Class<?> getDeclaringClass() {
        return this.signature.signature.declaringClass;
    }

    public Type getResultType() {
        return this.signature.signature.resultType;
    }

    public String getMethodName() {
        return this.signature.signature.methodName;
    }

    public Type[] getArgumentTypes() {
        return this.signature.signature.argumentTypes;
    }

    public Method getMethod() {
        try {
            return this.signature.signature.resolveMethod();
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public Type getThisType() {
        if (this.setupThis != null) {
            return this.setupThis.getType();
        }
        return this.signature.signature.declaringClass;
    }

    public Type[] getActualArgumentTypes() {
        return (Type[])Arrays.stream(this.setupArgs).map(arg -> arg.getValue() == null ? Object.class : arg.getValue().getType()).toArray(Type[]::new);
    }

    public SerializedValue getSetupThis() {
        return this.setupThis;
    }

    public Optional<SerializedValue> onSetupThis() {
        return Optional.ofNullable(this.setupThis);
    }

    public Stream<SerializedValue> streamSetupThis() {
        return Stream.of(this.setupThis).filter(Objects::nonNull);
    }

    public void setSetupThis(SerializedValue setupThis) {
        this.setupThis = setupThis;
    }

    public SerializedArgument[] getSetupArgs() {
        return this.setupArgs;
    }

    public Optional<SerializedArgument> onSetupArg(int index) {
        if (this.setupArgs.length <= index) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.setupArgs[index]);
    }

    public Stream<SerializedArgument> streamSetupArgs() {
        return Arrays.stream(this.setupArgs);
    }

    public void setSetupArgs(SerializedValue ... setupArgs) {
        this.setupArgs = this.argumentsOf(setupArgs);
    }

    public SerializedField[] getSetupGlobals() {
        return this.setupGlobals;
    }

    public Stream<SerializedField> streamSetupGlobals() {
        return Arrays.stream(this.setupGlobals);
    }

    public void setSetupGlobals(SerializedField ... setupGlobals) {
        this.setupGlobals = setupGlobals;
    }

    public SerializedValue getExpectThis() {
        return this.expectThis;
    }

    public Optional<SerializedValue> onExpectThis() {
        return Optional.ofNullable(this.expectThis);
    }

    public Stream<SerializedValue> streamExpectThis() {
        return Stream.of(this.expectThis).filter(Objects::nonNull);
    }

    public void setExpectThis(SerializedValue expectThis) {
        this.expectThis = expectThis;
    }

    public SerializedResult getExpectResult() {
        return this.expectResult;
    }

    public Optional<SerializedResult> onExpectResult() {
        return Optional.ofNullable(this.expectResult);
    }

    public Stream<SerializedResult> streamExpectResult() {
        return Stream.of(this.expectResult).filter(Objects::nonNull);
    }

    public void setExpectResult(SerializedValue expectResult) {
        this.expectResult = this.resultOf(expectResult);
    }

    public SerializedValue getExpectException() {
        return this.expectException;
    }

    public Optional<SerializedValue> onExpectException() {
        return Optional.ofNullable(this.expectException);
    }

    public Stream<SerializedValue> streamExpectException() {
        return Stream.of(this.expectException).filter(Objects::nonNull);
    }

    public void setExpectException(SerializedValue expectException) {
        this.expectException = expectException;
    }

    public SerializedArgument[] getExpectArgs() {
        return this.expectArgs;
    }

    public Stream<SerializedArgument> streamExpectArgs() {
        return Arrays.stream(this.expectArgs);
    }

    public Optional<SerializedArgument> onExpectArg(int index) {
        if (this.expectArgs.length <= index) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.expectArgs[index]);
    }

    public void setExpectArgs(SerializedValue ... expectArgs) {
        this.expectArgs = this.argumentsOf(expectArgs);
    }

    public SerializedField[] getExpectGlobals() {
        return this.expectGlobals;
    }

    public Stream<SerializedField> streamExpectGlobals() {
        return Arrays.stream(this.expectGlobals);
    }

    public void setExpectGlobals(SerializedField ... expectGlobals) {
        this.expectGlobals = expectGlobals;
    }

    public void addInput(SerializedInput input) {
        this.setupInput.add(input);
    }

    public Queue<SerializedInput> getSetupInput() {
        return this.setupInput;
    }

    public Stream<SerializedInput> streamInput() {
        return this.setupInput.stream();
    }

    public boolean hasSetupInput() {
        return !this.setupInput.isEmpty();
    }

    public boolean lastInputSatitisfies(Predicate<SerializedInput> predicate) {
        SerializedInput peek = this.setupInput.peekLast();
        return peek != null && predicate.test(peek);
    }

    public void addOutput(SerializedOutput output) {
        this.expectOutput.add(output);
    }

    public Queue<SerializedOutput> getExpectOutput() {
        return this.expectOutput;
    }

    public Stream<SerializedOutput> streamOutput() {
        return this.expectOutput.stream();
    }

    public boolean hasExpectOutput() {
        return !this.expectOutput.isEmpty();
    }

    public boolean lastOutputSatitisfies(Predicate<SerializedOutput> predicate) {
        SerializedOutput peek = this.expectOutput.peekLast();
        return peek != null && predicate.test(peek);
    }

    public BiOptional<SerializedValue> onThis() {
        return BiOptional.ofNullable((Object)this.setupThis, (Object)this.expectThis);
    }

    public BiOptional<SerializedArgument[]> onArgs() {
        return BiOptional.ofNullable((Object)this.setupArgs, (Object)this.expectArgs);
    }

    public BiOptional<SerializedField[]> onGlobals() {
        return BiOptional.ofNullable((Object)this.setupGlobals, (Object)this.expectGlobals);
    }

    public String toString() {
        return this.signature.toString();
    }

    private SerializedArgument[] argumentsOf(SerializedValue[] argumentValues) {
        SerializedArgument[] arguments = new SerializedArgument[argumentValues.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = new SerializedArgument(i, this.signature.signature, argumentValues[i]);
        }
        return arguments;
    }

    private SerializedResult resultOf(SerializedValue result) {
        return new SerializedResult(this.signature.signature, result);
    }
}

