/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.types;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import net.amygdalum.testrecorder.util.Types;

public class FieldSignature
implements Serializable {
    public Class<?> declaringClass;
    public Type type;
    public String fieldName;

    public FieldSignature(Class<?> declaringClass, Type type, String fieldName) {
        assert (declaringClass != null);
        assert (fieldName != null);
        assert (type != null);
        this.declaringClass = declaringClass;
        this.type = Types.serializableOf((Type)type);
        this.fieldName = fieldName;
    }

    public Field resolveField() throws NoSuchFieldException {
        return Types.getDeclaredField(this.declaringClass, (String)this.fieldName);
    }

    public int hashCode() {
        return this.declaringClass.hashCode() * 29 + this.fieldName.hashCode() * 17 + this.type.hashCode() * 11;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldSignature that = (FieldSignature)obj;
        return this.declaringClass.equals(that.declaringClass) && this.fieldName.equals(that.fieldName) && this.type.equals(that.type);
    }

    public String toString() {
        return this.type.getTypeName() + " " + this.fieldName + " of " + this.declaringClass.getName();
    }
}

