/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.types;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.amygdalum.testrecorder.types.TypeResolutionException;
import net.amygdalum.testrecorder.util.SerializableParameterizedType;
import net.amygdalum.testrecorder.util.SerializableWildcardType;
import net.amygdalum.testrecorder.util.Types;

public class GenericsResolver {
    private Map<Type, Type> groundTypes = new HashMap<Type, Type>();

    public GenericsResolver(Method method, Type[] actualArgumentTypes) {
        if (method == null) {
            throw new RuntimeException();
        }
        this.unify(method.getGenericParameterTypes(), actualArgumentTypes);
    }

    public Type resolve(Type type) {
        if (type instanceof Class) {
            return type;
        }
        Type resolvedType = this.resolveType(type);
        if (resolvedType != null) {
            return resolvedType;
        }
        resolvedType = this.resolveParametric(type);
        return resolvedType;
    }

    public Type[] resolve(Type[] types) {
        Type[] resolvedTypes = null;
        for (int i = 0; i < types.length; ++i) {
            Type unresolvedType = types[i];
            Type resolvedType = this.resolve(unresolvedType);
            if (resolvedTypes != null) {
                resolvedTypes[i] = resolvedType;
                continue;
            }
            if (unresolvedType == resolvedType) continue;
            resolvedTypes = new Type[types.length];
            System.arraycopy(types, 0, resolvedTypes, 0, i);
            resolvedTypes[i] = resolvedType;
        }
        if (resolvedTypes == null) {
            return types;
        }
        return resolvedTypes;
    }

    private void unify(Type[] types, Type[] targets) {
        if (targets.length != types.length) {
            return;
        }
        int len = targets.length;
        LinkedList<Unify> toresolve = new LinkedList<Unify>();
        for (int i = 0; i < len; ++i) {
            if (this.groundTypes.containsKey(types[i])) continue;
            Unify candidate = new Unify(targets[i], types[i]);
            toresolve.add(candidate);
        }
        int lastresolvedVariables = this.groundTypes.size();
        int newresolvedVariables = this.groundTypes.size();
        ArrayList<Unify> nexts = new ArrayList<Unify>();
        while (true) {
            if (!toresolve.isEmpty()) {
                Unify current = (Unify)toresolve.remove();
                Type type = current.type;
                Type target = current.target;
                this.unify(this.bind(type), target);
                if (this.groundTypes.containsKey(type)) continue;
                nexts.add(current);
                continue;
            }
            lastresolvedVariables = newresolvedVariables;
            newresolvedVariables = this.groundTypes.size();
            toresolve.addAll(nexts);
            nexts.clear();
            if (newresolvedVariables <= lastresolvedVariables) break;
        }
    }

    private Type bind(Type type) {
        if (type instanceof Class) {
            return type;
        }
        if (this.groundTypes.containsValue(type)) {
            return type;
        }
        Type ground = this.resolveType(type);
        if (ground == type) {
            return type;
        }
        if (ground != null) {
            return ground;
        }
        if (type instanceof ParameterizedType) {
            return this.bindParameterized((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return this.bindWildcard((WildcardType)type);
        }
        return type;
    }

    private Type bindParameterized(ParameterizedType parameterizedType) {
        Type[] boundTypeArguments;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments == (boundTypeArguments = this.bindArray(actualTypeArguments))) {
            return parameterizedType;
        }
        SerializableParameterizedType type = Types.parameterized((Type)parameterizedType.getRawType(), (Type)parameterizedType.getOwnerType(), (Type[])boundTypeArguments);
        boolean ground = true;
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            ground &= this.groundTypes.containsKey(actualTypeArguments[i]);
        }
        if (ground) {
            this.assignGround(parameterizedType, (Type)type);
        }
        return type;
    }

    private Type bindWildcard(WildcardType wildCardType) {
        int i;
        Type[] actualUpperBounds = wildCardType.getUpperBounds();
        Type[] boundUpperBounds = this.bindArray(actualUpperBounds);
        Type[] actualLowerBounds = wildCardType.getLowerBounds();
        Type[] boundLowerBounds = this.bindArray(actualLowerBounds);
        if (actualUpperBounds == boundUpperBounds && actualLowerBounds == boundLowerBounds) {
            return wildCardType;
        }
        SerializableWildcardType type = Types.wildcard((Type[])boundUpperBounds, (Type[])boundLowerBounds);
        boolean ground = true;
        for (i = 0; i < actualUpperBounds.length; ++i) {
            ground &= this.groundTypes.containsKey(actualUpperBounds[i]);
        }
        for (i = 0; i < actualLowerBounds.length; ++i) {
            ground &= this.groundTypes.containsKey(actualLowerBounds[i]);
        }
        if (ground) {
            this.assignGround(wildCardType, (Type)type);
        }
        return type;
    }

    private Type[] bindArray(Type[] types) {
        Type[] resolvedTypes = null;
        for (int i = 0; i < types.length; ++i) {
            Type unresolvedType = types[i];
            Type resolvedType = this.bind(unresolvedType);
            if (resolvedTypes != null) {
                resolvedTypes[i] = resolvedType;
                continue;
            }
            if (unresolvedType == resolvedType) continue;
            resolvedTypes = new Type[types.length];
            System.arraycopy(types, 0, resolvedTypes, 0, i);
            resolvedTypes[i] = resolvedType;
        }
        if (resolvedTypes == null) {
            return types;
        }
        return resolvedTypes;
    }

    private Type unify(Type type, Type target) {
        if (type == target) {
            return type;
        }
        if (type instanceof Class) {
            if (Types.assignableTypes((Type)type, (Type)target)) {
                return type;
            }
            throw new TypeResolutionException("signatures are not unifiable");
        }
        if (type instanceof TypeVariable) {
            return this.unifyVariable((TypeVariable)type, target);
        }
        if (type instanceof ParameterizedType) {
            return this.unifyParameterized((ParameterizedType)type, target);
        }
        if (type instanceof WildcardType) {
            return this.unifyWildcard((WildcardType)type, target);
        }
        if (type instanceof GenericArrayType) {
            return this.unifyGenericArrayType((GenericArrayType)type, target);
        }
        throw new TypeResolutionException("signatures are not unifiable");
    }

    private Type unifyParameterized(ParameterizedType parameterizedType, Type target) {
        if (Types.assignableTypes((Type)parameterizedType, (Type)target)) {
            return parameterizedType;
        }
        return target;
    }

    private Type unifyWildcard(WildcardType wildcardType, Type target) {
        for (Type bound : wildcardType.getUpperBounds()) {
            if (Types.assignableTypes((Type)bound, (Type)target)) continue;
            return wildcardType;
        }
        for (Type bound : wildcardType.getLowerBounds()) {
            if (Types.assignableTypes((Type)target, (Type)bound)) continue;
            return wildcardType;
        }
        return target;
    }

    private Type unifyGenericArrayType(GenericArrayType genericArrayType, Type target) {
        if (Types.assignableTypes((Type)genericArrayType, (Type)target)) {
            return genericArrayType;
        }
        return target;
    }

    private Type unifyVariable(TypeVariable<?> typeVariable, Type target) {
        this.assignGround(typeVariable, target);
        return target;
    }

    private void assignGround(Type type, Type target) {
        this.groundTypes.put(Types.serializableOf((Type)type), target);
    }

    private Type resolveType(Type type) {
        return this.groundTypes.get(Types.serializableOf((Type)type));
    }

    private Type resolveType(Type type, Type defaultType) {
        return this.groundTypes.getOrDefault(Types.serializableOf((Type)type), defaultType);
    }

    private Type resolveParametric(Type type) {
        if (type instanceof GenericArrayType) {
            Type resolvedComponentType;
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type unresolvedComponentType = genericArrayType.getGenericComponentType();
            if (unresolvedComponentType == (resolvedComponentType = this.resolve(unresolvedComponentType))) {
                return type;
            }
            return Types.genericArray((Type)resolvedComponentType);
        }
        if (type instanceof ParameterizedType) {
            Type[] resolvedTypeArguments;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] unresolvedTypeArguments = parameterizedType.getActualTypeArguments();
            if (unresolvedTypeArguments == (resolvedTypeArguments = this.resolve(unresolvedTypeArguments))) {
                return type;
            }
            return Types.parameterized((Type)parameterizedType.getRawType(), (Type)parameterizedType.getOwnerType(), (Type[])resolvedTypeArguments);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return this.resolveType(typeVariable, type);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] unresolvedLowerBounds = wildcardType.getLowerBounds();
            Type[] resolvedLowerBounds = this.resolve(unresolvedLowerBounds);
            Type[] unresolvedUpperBounds = wildcardType.getUpperBounds();
            Type[] resolvedUpperBounds = this.resolve(unresolvedUpperBounds);
            if (unresolvedLowerBounds == resolvedLowerBounds && unresolvedUpperBounds == resolvedUpperBounds) {
                return type;
            }
            return Types.wildcard((Type[])resolvedUpperBounds, (Type[])resolvedLowerBounds);
        }
        return type;
    }

    private static class Unify {
        public Type target;
        public Type type;

        Unify(Type target, Type type) {
            this.target = target;
            this.type = type;
        }
    }
}

