/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.types;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class LocalVariableNameGenerator {
    private Map<String, FreeIndexes> names = new HashMap<String, FreeIndexes>();

    public String fetchName(Type type) {
        return this.fetchName(this.base(type));
    }

    public String fetchName(String base) {
        if (base.isEmpty() || Character.isDigit(base.charAt(base.length() - 1))) {
            base = base + "_";
        }
        return base + this.names.computeIfAbsent(base, key -> new FreeIndexes()).next();
    }

    private String base(Type type) {
        if (type instanceof Class) {
            return this.base((Class)type);
        }
        if (type instanceof GenericArrayType) {
            return this.base(((GenericArrayType)type).getGenericComponentType()) + "Array";
        }
        if (type instanceof ParameterizedType) {
            return this.base(((ParameterizedType)type).getRawType());
        }
        return this.normalize(type.getTypeName());
    }

    private String base(Class<?> clazz) {
        if (clazz.isArray()) {
            return this.base(clazz.getComponentType()) + "Array";
        }
        return this.variableName(clazz);
    }

    private String variableName(Class<?> clazz) {
        String variableName = clazz.getSimpleName();
        if (variableName.isEmpty()) {
            String fullName = clazz.getName();
            int lastdot = fullName.lastIndexOf(46);
            variableName = fullName.substring(lastdot + 1);
        }
        return this.normalize(variableName);
    }

    private String normalize(String name) {
        if (name.isEmpty()) {
            return "_";
        }
        char lastChar = (name = name.replaceAll("[^\\w$]+", "_").replaceAll("^_+|_+$", "")).charAt(name.length() - 1);
        if (Character.isDigit(lastChar)) {
            name = name + '_';
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public void freeName(String name) {
        int pos = this.splitNameAndIndex(name);
        String base = name.substring(0, pos);
        int index = Integer.parseInt(name.substring(pos));
        FreeIndexes free = this.names.get(base);
        if (free != null) {
            free.free(index);
        }
    }

    private int splitNameAndIndex(String name) {
        int pos;
        for (pos = name.length() - 1; pos >= 0 && Character.isDigit(name.charAt(pos)); --pos) {
        }
        return pos + 1;
    }

    private static class FreeIndexes {
        private int last = 0;
        private BitSet free;

        FreeIndexes() {
        }

        public void free(int index) {
            if (this.last == index) {
                --this.last;
            } else if (index < this.last) {
                if (this.free == null) {
                    this.free = new BitSet();
                }
                this.free.set(index);
            }
        }

        public int next() {
            if (this.free != null) {
                int next = this.free.nextSetBit(0);
                if (next != -1) {
                    this.free.clear(next);
                    return next;
                }
                this.free = null;
            }
            ++this.last;
            return this.last;
        }
    }
}

