/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.types;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.util.Types;

public class MethodSignature
implements Serializable {
    public Class<?> declaringClass;
    public Type resultType;
    public String methodName;
    public Type[] argumentTypes;

    public MethodSignature(Class<?> declaringClass, Type resultType, String methodName, Type[] argumentTypes) {
        assert (declaringClass != null);
        assert (methodName != null);
        assert (resultType != null);
        assert (argumentTypes != null);
        this.declaringClass = declaringClass;
        this.resultType = Types.serializableOf((Type)resultType);
        this.methodName = methodName;
        this.argumentTypes = Types.serializableOf((Type[])argumentTypes);
    }

    public ClassLoader getClassLoader() {
        return this.declaringClass.getClassLoader();
    }

    public Method resolveMethod() throws NoSuchMethodException {
        return Types.getDeclaredMethod(this.declaringClass, (String)this.methodName, (Class[])this.getParameterTypes());
    }

    private Class<?>[] getParameterTypes() {
        return (Class[])Arrays.stream(this.argumentTypes).map(type -> Types.baseType((Type)type)).toArray(Class[]::new);
    }

    public int hashCode() {
        return this.declaringClass.hashCode() * 37 + this.methodName.hashCode() * 29 + this.resultType.hashCode() * 17 + Arrays.hashCode(this.argumentTypes) * 11;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignature that = (MethodSignature)obj;
        return this.declaringClass.equals(that.declaringClass) && this.methodName.equals(that.methodName) && this.resultType.equals(that.resultType) && Arrays.equals(this.argumentTypes, that.argumentTypes);
    }

    public String toString() {
        return this.resultType.getTypeName() + " " + this.methodName + Stream.of(this.argumentTypes).map(type -> type.getTypeName()).collect(Collectors.joining(",", "(", ")")) + " of " + this.declaringClass.getName();
    }
}

