/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.types;

public class Profile
implements Comparable<Profile> {
    public long start;
    public long duration;
    public Class<?> type;

    private Profile(Class<?> type) {
        this.type = type;
        this.duration = Long.MAX_VALUE;
    }

    public static Profile start(Class<?> type) {
        Profile serialization = new Profile(type);
        serialization.start = System.currentTimeMillis();
        return serialization;
    }

    public Profile stop() {
        this.duration = System.currentTimeMillis() - this.start;
        return this;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public int compareTo(Profile that) {
        int compare = Long.compare(that.duration, this.duration);
        if (compare == 0) {
            compare = Long.compare(this.start, that.start);
        }
        return compare;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Profile that = (Profile)obj;
        return this.type.equals(that.type);
    }

    public String toString() {
        return this.type.getName() + ":" + (this.duration == Long.MAX_VALUE ? "timeout" : Long.valueOf(this.duration));
    }
}

