/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.types;

import java.io.Serializable;
import java.lang.reflect.Type;
import net.amygdalum.testrecorder.types.MethodSignature;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedRole;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.util.Types;

public class SerializedArgument
implements Comparable<SerializedArgument>,
Serializable,
SerializedRole {
    private int index;
    private MethodSignature signature;
    private SerializedValue value;

    public SerializedArgument(int index, MethodSignature signature, SerializedValue value) {
        assert (signature != null);
        assert (value != null);
        this.index = index;
        this.signature = signature;
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public MethodSignature getSignature() {
        return this.signature;
    }

    public Type getType() {
        return this.signature.argumentTypes[this.index];
    }

    public SerializedValue getValue() {
        return this.value;
    }

    @Override
    public <T> T accept(RoleVisitor<T> visitor) {
        return visitor.visitArgument(this);
    }

    public String toString() {
        return "(" + this.signature.argumentTypes[this.index].getTypeName() + " " + Types.baseType((Type)this.signature.argumentTypes[this.index]).getSimpleName().toLowerCase() + this.index + ": " + this.value.toString() + ")";
    }

    public int hashCode() {
        return this.index * 37 + this.signature.hashCode() * 17 + this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializedArgument that = (SerializedArgument)obj;
        return this.index == that.index && this.signature.equals(that.signature) && this.value.equals(that.value);
    }

    @Override
    public int compareTo(SerializedArgument o) {
        return Integer.compare(this.index, o.index);
    }
}

