/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.types;

import java.io.Serializable;
import java.lang.reflect.Type;
import net.amygdalum.testrecorder.types.FieldSignature;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedRole;
import net.amygdalum.testrecorder.types.SerializedValue;

public class SerializedField
implements Comparable<SerializedField>,
Serializable,
SerializedRole {
    private FieldSignature signature;
    private SerializedValue value;

    public SerializedField(FieldSignature signature, SerializedValue value) {
        assert (signature != null);
        assert (value != null);
        this.signature = signature;
        this.value = value;
    }

    public FieldSignature getSignature() {
        return this.signature;
    }

    public Class<?> getDeclaringClass() {
        return this.signature.declaringClass;
    }

    public String getName() {
        return this.signature.fieldName;
    }

    public Type getType() {
        return this.signature.type;
    }

    public SerializedValue getValue() {
        return this.value;
    }

    @Override
    public <T> T accept(RoleVisitor<T> visitor) {
        return visitor.visitField(this);
    }

    public String toString() {
        return this.signature.type.getTypeName() + " " + this.signature.fieldName + ": " + this.value.toString();
    }

    public int hashCode() {
        return this.signature.hashCode() * 31 + this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializedField that = (SerializedField)obj;
        return this.signature.equals(that.signature) && this.value.equals(that.value);
    }

    @Override
    public int compareTo(SerializedField o) {
        return this.getName().compareTo(o.getName());
    }
}

