/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.types;

import java.io.Serializable;
import java.lang.reflect.Type;
import net.amygdalum.testrecorder.types.MethodSignature;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedRole;
import net.amygdalum.testrecorder.types.SerializedValue;

public class SerializedResult
implements Serializable,
SerializedRole {
    private MethodSignature signature;
    private SerializedValue value;

    public SerializedResult(MethodSignature signature, SerializedValue value) {
        assert (signature != null);
        assert (value != null);
        this.signature = signature;
        this.value = value;
    }

    public MethodSignature getSignature() {
        return this.signature;
    }

    public Type getType() {
        return this.signature.resultType;
    }

    public SerializedValue getValue() {
        return this.value;
    }

    @Override
    public <T> T accept(RoleVisitor<T> visitor) {
        return visitor.visitResult(this);
    }

    public String toString() {
        return "=>" + this.signature.resultType.getTypeName() + ": " + this.value.toString();
    }

    public int hashCode() {
        return this.signature.hashCode() * 13 + this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializedResult that = (SerializedResult)obj;
        return this.signature.equals(that.signature) && this.value.equals(that.value);
    }
}

