/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.types;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.amygdalum.testrecorder.types.MethodSignature;
import net.amygdalum.testrecorder.util.Types;

public class VirtualMethodSignature
implements Serializable {
    public static final VirtualMethodSignature NULL = new VirtualMethodSignature(){

        @Override
        public synchronized boolean validIn(Class<?> clazz) {
            return false;
        }

        @Override
        public String toString() {
            return "NULL";
        }
    };
    public MethodSignature signature;
    private Set<Class<?>> valid;
    private Set<Class<?>> invalid;

    private VirtualMethodSignature() {
        this.valid = new HashSet();
        this.invalid = new HashSet();
    }

    public VirtualMethodSignature(MethodSignature signature) {
        this.signature = signature;
        this.valid = new HashSet();
        this.invalid = new HashSet();
    }

    public static VirtualMethodSignature fromDescriptor(Method method) {
        return VirtualMethodSignature.fromDescriptor(method.getDeclaringClass(), method);
    }

    public static VirtualMethodSignature fromDescriptor(Class<?> clazz, Method method) {
        MethodSignature signature = new MethodSignature(clazz, method.getGenericReturnType(), method.getName(), method.getGenericParameterTypes());
        return new VirtualMethodSignature(signature);
    }

    public ClassLoader getClassLoader() {
        return this.signature.getClassLoader();
    }

    public synchronized boolean validIn(Class<?> clazz) {
        if (this.valid.contains(clazz)) {
            return true;
        }
        if (this.invalid.contains(clazz)) {
            return false;
        }
        try {
            Class<?> resolvedClass = this.resolveClass(clazz);
            boolean valid = Objects.equals(resolvedClass.getName(), this.signature.declaringClass.getName());
            if (valid) {
                this.valid.add(clazz);
            } else {
                this.invalid.add(clazz);
            }
            return valid;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private Class<?> resolveClass(Class<?> clazz) throws NoSuchMethodException {
        ClassLoader loader = clazz.getClassLoader();
        Class[] parameterTypes = (Class[])Arrays.stream(this.signature.argumentTypes).map(type -> {
            try {
                return Types.classFrom((Class)Types.baseType((Type)type), (ClassLoader)loader);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }).toArray(Class[]::new);
        Method method = Types.getDeclaredMethod(clazz, (String)this.signature.methodName, (Class[])parameterTypes);
        return method.getDeclaringClass();
    }

    public String toString() {
        return this.signature.toString();
    }
}

