/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.values.AbstractSerializedValue;

public abstract class AbstractSerializedReferenceType
extends AbstractSerializedValue
implements SerializedReferenceType {
    private int id;
    private Type[] usedTypes;

    public AbstractSerializedReferenceType(Class<?> type) {
        super(type);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public Type[] getUsedTypes() {
        if (this.usedTypes == null) {
            return super.getUsedTypes();
        }
        return this.usedTypes;
    }

    @Override
    public void useAs(Type type) {
        assert (type instanceof Serializable);
        if (this.usedTypes == null) {
            this.usedTypes = new Type[]{type};
            return;
        }
        Type[] types = this.usedTypes;
        int pos = Arrays.binarySearch(types, type, Comparator.comparing(Type::getTypeName));
        if (pos < 0) {
            this.usedTypes = new Type[types.length + 1];
            int index = -pos - 1;
            System.arraycopy(types, 0, this.usedTypes, 0, index);
            this.usedTypes[index] = type;
            System.arraycopy(types, index, this.usedTypes, index + 1, types.length - index);
        }
    }
}

