/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.util.Types;

public abstract class AbstractSerializedValue
implements SerializedValue {
    private Class<?> type;

    public AbstractSerializedValue(Class<?> type) {
        assert (type == null || type instanceof Serializable);
        this.type = type;
    }

    @Override
    public Type[] getUsedTypes() {
        return new Type[]{this.type};
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public Type inferType(Stream<Type> candidateTypes, Collection<SerializedValue> values, Class<?> defaultType) {
        return candidateTypes.filter(type -> this.satisfiesType((Type)type, (Collection<? extends SerializedValue>)values)).sorted(Types::byMostConcreteGeneric).findFirst().orElse(defaultType);
    }

    public boolean satisfiesType(Type type, SerializedValue value) {
        Class baseType = Types.baseType((Type)type);
        return value.getType() == null || baseType.isAssignableFrom(Types.baseType(value.getType()));
    }

    public boolean satisfiesType(Type type, Collection<? extends SerializedValue> collection) {
        return collection.stream().allMatch(value -> this.satisfiesType(type, (SerializedValue)value));
    }
}

