/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.amygdalum.testrecorder.asm.ByteCode;

public class LambdaSignature
implements Serializable {
    private String capturingClass;
    private String instantiatedMethodType;
    private String functionalInterfaceClass;
    private String functionalInterfaceMethodName;
    private String functionalInterfaceMethodSignature;
    private String implClass;
    private int implMethodKind;
    private String implMethodName;
    private String implMethodSignature;

    public LambdaSignature withCapturingClass(String capturingClass) {
        this.capturingClass = capturingClass;
        return this;
    }

    public LambdaSignature withInstantiatedMethodType(String instantiatedMethodType) {
        this.instantiatedMethodType = instantiatedMethodType;
        return this;
    }

    public LambdaSignature withFunctionalInterface(String functionalInterfaceClass, String functionalInterfaceMethodName, String functionalInterfaceMethodSignature) {
        this.functionalInterfaceClass = functionalInterfaceClass;
        this.functionalInterfaceMethodName = functionalInterfaceMethodName;
        this.functionalInterfaceMethodSignature = functionalInterfaceMethodSignature;
        return this;
    }

    public LambdaSignature withImplMethod(String implClass, int implMethodKind, String implMethodName, String implMethodSignature) {
        this.implClass = implClass;
        this.implMethodKind = implMethodKind;
        this.implMethodName = implMethodName;
        this.implMethodSignature = implMethodSignature;
        return this;
    }

    public <T> T deserialize(Class<T> resultType, Object ... capturedArgs) {
        try {
            Class capturingClass = ByteCode.classFrom((String)this.capturingClass, (ClassLoader)resultType.getClassLoader());
            ClassLoader cl = capturingClass.getClassLoader();
            Class implClass = ByteCode.classFrom((String)this.implClass, (ClassLoader)cl);
            Class interfaceType = ByteCode.classFrom((String)this.functionalInterfaceClass, (ClassLoader)cl);
            MethodHandles.Lookup lookup = this.privateLookup(implClass);
            MethodType implMethodType = MethodType.fromMethodDescriptorString(this.implMethodSignature, cl);
            MethodType interfaceMethodType = MethodType.fromMethodDescriptorString(this.functionalInterfaceMethodSignature, null);
            MethodHandle implMethod = this.implMethod(lookup, implClass, implMethodType);
            MethodType factoryMethodType = this.factoryType(interfaceType, interfaceMethodType, implClass, implMethodType);
            MethodType instantiatedMethodType = this.instantiatedType(interfaceMethodType, implMethodType);
            CallSite callSite = LambdaMetafactory.altMetafactory(lookup, this.functionalInterfaceMethodName, factoryMethodType, interfaceMethodType, implMethod, instantiatedMethodType, 1);
            return (T)callSite.dynamicInvoker().invokeWithArguments(capturedArgs);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private MethodType factoryType(Class<?> interfaceType, MethodType interfaceMethodType, Class<?> implClass, MethodType implMethodType) {
        MethodType factoryType = MethodType.methodType(interfaceType, Arrays.copyOf(implMethodType.parameterArray(), implMethodType.parameterCount() - interfaceMethodType.parameterCount()));
        if (this.isInstanceMethod()) {
            return factoryType.insertParameterTypes(0, implClass);
        }
        return factoryType;
    }

    private MethodType instantiatedType(MethodType interfaceMethodType, MethodType implType) {
        if (implType.parameterCount() > interfaceMethodType.parameterCount()) {
            return implType.dropParameterTypes(0, implType.parameterCount() - interfaceMethodType.parameterCount());
        }
        if (implType.returnType() == Void.TYPE && interfaceMethodType.returnType() != Void.TYPE) {
            return implType.changeReturnType((Class<?>)interfaceMethodType.returnType());
        }
        return implType;
    }

    private boolean isInstanceMethod() {
        return this.implMethodKind != 6 && this.implMethodKind != 8;
    }

    private MethodHandle implMethod(MethodHandles.Lookup lookup, Class<?> implClass, MethodType implType) throws NoSuchMethodException, IllegalAccessException {
        switch (this.implMethodKind) {
            case 5: 
            case 9: {
                return lookup.findVirtual(implClass, this.implMethodName, implType);
            }
            case 7: {
                return lookup.findSpecial(implClass, this.implMethodName, implType, implClass);
            }
            case 6: {
                return lookup.findStatic(implClass, this.implMethodName, implType);
            }
            case 8: {
                return lookup.findConstructor(implClass, implType);
            }
        }
        throw new RuntimeException("Unsupported impl method kind " + this.implMethodKind);
    }

    private MethodHandles.Lookup privateLookup(Class<?> clazz) throws ReflectiveOperationException {
        Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        constructor.setAccessible(true);
        return (MethodHandles.Lookup)constructor.newInstance(clazz, 15);
    }

    public String getCapturingClass() {
        return this.capturingClass;
    }

    public String getInstantiatedMethodType() {
        return this.instantiatedMethodType;
    }

    public String getFunctionalInterfaceClass() {
        return this.functionalInterfaceClass;
    }

    public String getFunctionalInterfaceMethodName() {
        return this.functionalInterfaceMethodName;
    }

    public String getFunctionalInterfaceMethodSignature() {
        return this.functionalInterfaceMethodSignature;
    }

    public String getImplClass() {
        return this.implClass;
    }

    public int getImplMethodKind() {
        return this.implMethodKind;
    }

    public String getImplMethodName() {
        return this.implMethodName;
    }

    public String getImplMethodSignature() {
        return this.implMethodSignature;
    }
}

