/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.types.ReferenceTypeVisitor;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedAggregateType;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.AbstractSerializedReferenceType;
import net.amygdalum.testrecorder.values.ValuePrinter;

public class SerializedArray
extends AbstractSerializedReferenceType
implements SerializedAggregateType {
    private Type componentType;
    private List<SerializedValue> array;

    public SerializedArray(Class<?> type) {
        super(type);
        this.componentType = type.getComponentType();
        this.array = new ArrayList<SerializedValue>();
    }

    @Override
    public List<SerializedValue> elements() {
        return this.array.stream().distinct().collect(Collectors.toList());
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public Class<?> getRawType() {
        return Types.baseType((Type)this.getComponentType());
    }

    public SerializedValue[] getArray() {
        return this.array.toArray(new SerializedValue[0]);
    }

    public List<SerializedValue> getArrayAsList() {
        return this.array;
    }

    private Stream<Type> getComponentTypeCandidates() {
        return Arrays.stream(this.getUsedTypes()).filter(Types::isArray).map(Types::component);
    }

    @Override
    public void useAs(Type type) {
        super.useAs(type);
        if (this.componentType == null || !Types.baseType((Type)this.componentType).isPrimitive()) {
            this.componentType = this.inferType(this.getComponentTypeCandidates(), this.array, this.getType().getComponentType());
        }
    }

    @Override
    public List<SerializedValue> referencedValues() {
        return this.elements();
    }

    @Override
    public <T> T accept(RoleVisitor<T> visitor) {
        return visitor.visitReferenceType(this);
    }

    @Override
    public <T> T accept(ReferenceTypeVisitor<T> visitor) {
        return visitor.visitAggregateType(this);
    }

    public SerializedValue get(int index) {
        return this.array.get(index);
    }

    public int size() {
        return this.array.size();
    }

    public void add(SerializedValue value) {
        this.array.add(value);
        if (!this.satisfiesType(this.componentType, value)) {
            this.componentType = this.inferType(this.getComponentTypeCandidates(), this.array, this.getType().getComponentType());
        }
    }

    public String toString() {
        return ValuePrinter.print(this);
    }
}

