/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.types.ReferenceTypeVisitor;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedAggregateType;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.util.Optionals;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.AbstractSerializedReferenceType;
import net.amygdalum.testrecorder.values.ValuePrinter;

public class SerializedList
extends AbstractSerializedReferenceType
implements SerializedAggregateType,
Collection<SerializedValue> {
    private Type componentType = Object.class;
    private List<SerializedValue> list = new ArrayList<SerializedValue>();

    public SerializedList(Class<?> type) {
        super(type);
    }

    @Override
    public List<SerializedValue> elements() {
        return this.list.stream().distinct().collect(Collectors.toList());
    }

    public Type getComponentType() {
        return this.componentType;
    }

    private Stream<Type> getComponentTypeCandidates() {
        return Arrays.stream(this.getUsedTypes()).filter(type -> Types.typeArguments((Type)type).count() == 1L).flatMap(type -> Optionals.stream((Optional)Types.typeArgument((Type)type, (int)0)));
    }

    @Override
    public void useAs(Type type) {
        super.useAs(type);
        this.componentType = this.inferType(this.getComponentTypeCandidates(), this.list, Object.class);
    }

    @Override
    public <T> T accept(RoleVisitor<T> visitor) {
        return visitor.visitReferenceType(this);
    }

    @Override
    public <T> T accept(ReferenceTypeVisitor<T> visitor) {
        return visitor.visitAggregateType(this);
    }

    public SerializedValue get(int index) {
        return this.list.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<SerializedValue> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(SerializedValue element) {
        boolean added = this.list.add(element);
        if (!this.satisfiesType(this.componentType, element)) {
            this.componentType = this.inferType(this.getComponentTypeCandidates(), this.list, Object.class);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends SerializedValue> c) {
        boolean added = this.list.addAll(c);
        if (!this.satisfiesType(this.componentType, c)) {
            this.componentType = this.inferType(this.getComponentTypeCandidates(), this.list, Object.class);
        }
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public List<SerializedValue> referencedValues() {
        return this.elements();
    }

    public String toString() {
        return ValuePrinter.print(this);
    }
}

