/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.SerializedValueType;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.AbstractSerializedValue;
import net.amygdalum.testrecorder.values.ValuePrinter;

public class SerializedLiteral
extends AbstractSerializedValue
implements SerializedValueType {
    private static final Map<Object, SerializedLiteral> KNOWN_PRIMITIVE_LITERALS = new HashMap<Object, SerializedLiteral>();
    private static final Map<Object, SerializedLiteral> KNOWN_LITERALS = new HashMap<Object, SerializedLiteral>();
    private Object value;

    private SerializedLiteral(Class<?> type, Object value) {
        super(type);
        this.value = value;
    }

    public static SerializedLiteral literal(Object value) {
        return SerializedLiteral.literal(value.getClass(), value);
    }

    public static SerializedLiteral literal(Type type, Object value) {
        if (Types.baseType((Type)type).isPrimitive()) {
            return KNOWN_PRIMITIVE_LITERALS.computeIfAbsent(value, val -> new SerializedLiteral(Types.baseType((Type)type), val));
        }
        return KNOWN_LITERALS.computeIfAbsent(value, val -> new SerializedLiteral(Types.baseType((Type)type), val));
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public List<SerializedValue> referencedValues() {
        return Collections.emptyList();
    }

    @Override
    public <T> T accept(RoleVisitor<T> visitor) {
        return visitor.visitValueType(this);
    }

    public String toString() {
        return ValuePrinter.print(this);
    }
}

