/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.types.ReferenceTypeVisitor;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedAggregateType;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.util.Optionals;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.AbstractSerializedReferenceType;
import net.amygdalum.testrecorder.values.ValuePrinter;

public class SerializedMap
extends AbstractSerializedReferenceType
implements SerializedAggregateType,
Map<SerializedValue, SerializedValue> {
    private Type keyType = Object.class;
    private Type valueType = Object.class;
    private Map<SerializedValue, SerializedValue> map = new LinkedHashMap<SerializedValue, SerializedValue>();

    public SerializedMap(Class<?> type) {
        super(type);
    }

    @Override
    public List<SerializedValue> elements() {
        return this.map.entrySet().stream().flatMap(entry -> Stream.of((SerializedValue)entry.getKey(), (SerializedValue)entry.getValue())).distinct().collect(Collectors.toList());
    }

    public Type getMapKeyType() {
        return this.keyType;
    }

    public Type getMapValueType() {
        return this.valueType;
    }

    private Stream<Type> getKeyTypeCandidates() {
        return Arrays.stream(this.getUsedTypes()).filter(type -> Types.typeArguments((Type)type).count() == 2L).flatMap(type -> Optionals.stream((Optional)Types.typeArgument((Type)type, (int)0)));
    }

    private Stream<Type> getValueTypeCandidates() {
        return Arrays.stream(this.getUsedTypes()).filter(type -> Types.typeArguments((Type)type).count() == 2L).flatMap(type -> Optionals.stream((Optional)Types.typeArgument((Type)type, (int)1)));
    }

    @Override
    public void useAs(Type type) {
        super.useAs(type);
        this.keyType = this.inferType(this.getKeyTypeCandidates(), this.map.keySet(), Object.class);
        this.valueType = this.inferType(this.getValueTypeCandidates(), this.map.values(), Object.class);
    }

    @Override
    public <T> T accept(RoleVisitor<T> visitor) {
        return visitor.visitReferenceType(this);
    }

    @Override
    public <T> T accept(ReferenceTypeVisitor<T> visitor) {
        return visitor.visitAggregateType(this);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public SerializedValue get(Object key) {
        return this.map.get(key);
    }

    @Override
    public SerializedValue put(SerializedValue key, SerializedValue value) {
        SerializedValue replaced = this.map.put(key, value);
        if (!this.satisfiesType(this.keyType, key)) {
            this.keyType = this.inferType(this.getKeyTypeCandidates(), this.map.keySet(), Object.class);
        }
        if (!this.satisfiesType(this.valueType, value)) {
            this.valueType = this.inferType(this.getValueTypeCandidates(), this.map.values(), Object.class);
        }
        return replaced;
    }

    @Override
    public SerializedValue remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends SerializedValue, ? extends SerializedValue> m) {
        this.map.putAll(m);
        if (!this.satisfiesType(this.keyType, m.keySet())) {
            this.keyType = this.inferType(this.getKeyTypeCandidates(), this.map.keySet(), Object.class);
        }
        if (!this.satisfiesType(this.valueType, m.values())) {
            this.valueType = this.inferType(this.getValueTypeCandidates(), this.map.values(), Object.class);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<SerializedValue> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<SerializedValue> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<SerializedValue, SerializedValue>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public List<SerializedValue> referencedValues() {
        ArrayList<SerializedValue> referenced = new ArrayList<SerializedValue>(this.map.keySet());
        referenced.addAll(this.map.values());
        return referenced;
    }

    public String toString() {
        return ValuePrinter.print(this);
    }
}

