/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.types.ReferenceTypeVisitor;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedStructuralType;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.values.AbstractSerializedReferenceType;
import net.amygdalum.testrecorder.values.ValuePrinter;

public class SerializedObject
extends AbstractSerializedReferenceType
implements SerializedStructuralType {
    private List<SerializedField> fields = new ArrayList<SerializedField>();

    public SerializedObject(Class<?> type) {
        super(type);
    }

    public SerializedObject withFields(List<SerializedField> fields) {
        this.fields.addAll(fields);
        return this;
    }

    public SerializedObject withFields(SerializedField ... fields) {
        return this.withFields(Arrays.asList(fields));
    }

    @Override
    public List<SerializedField> fields() {
        return new ArrayList<SerializedField>(this.fields);
    }

    public List<SerializedField> getFields() {
        return this.fields;
    }

    public Optional<SerializedField> getField(String name) {
        return this.fields.stream().filter(field -> name.equals(field.getName())).findFirst();
    }

    public void addField(SerializedField field) {
        this.fields.add(field);
    }

    @Override
    public <T> T accept(RoleVisitor<T> visitor) {
        return visitor.visitReferenceType(this);
    }

    @Override
    public <T> T accept(ReferenceTypeVisitor<T> visitor) {
        return visitor.visitStructuralType(this);
    }

    @Override
    public List<SerializedValue> referencedValues() {
        return this.fields.stream().map(field -> field.getValue()).collect(Collectors.toList());
    }

    public String toString() {
        return ValuePrinter.print(this);
    }
}

