/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.types.ReferenceTypeVisitor;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedImmutableType;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.values.AbstractSerializedReferenceType;
import net.amygdalum.testrecorder.values.SerializedImmutable;
import net.amygdalum.testrecorder.values.ValuePrinter;

public class SerializedProxy
extends AbstractSerializedReferenceType
implements SerializedImmutableType {
    private List<SerializedImmutable<Class<?>>> interfaces;
    private SerializedValue invocationHandler;
    private List<SerializedField> fields = new ArrayList<SerializedField>();

    public SerializedProxy(Type type) {
        super(Proxy.class);
    }

    @Override
    public <T> T accept(RoleVisitor<T> visitor) {
        return visitor.visitReferenceType(this);
    }

    @Override
    public <T> T accept(ReferenceTypeVisitor<T> visitor) {
        return visitor.visitImmutableType(this);
    }

    public void setInterfaces(List<SerializedImmutable<Class<?>>> interfaces) {
        this.interfaces = interfaces;
    }

    public List<SerializedImmutable<Class<?>>> getInterfaces() {
        return this.interfaces;
    }

    public void setInvocationHandler(SerializedValue invocationHandler) {
        this.invocationHandler = invocationHandler;
    }

    public SerializedValue getInvocationHandler() {
        return this.invocationHandler;
    }

    public List<SerializedField> getFields() {
        return this.fields;
    }

    public Optional<SerializedField> getField(String name) {
        return this.fields.stream().filter(field -> name.equals(field.getName())).findFirst();
    }

    public void addField(SerializedField field) {
        this.fields.add(field);
    }

    @Override
    public List<SerializedValue> referencedValues() {
        ArrayList<SerializedValue> referencedValues = new ArrayList<SerializedValue>();
        referencedValues.addAll(this.interfaces);
        referencedValues.add(this.invocationHandler);
        referencedValues.addAll(this.fields.stream().map(field -> field.getValue()).collect(Collectors.toList()));
        return referencedValues;
    }

    public String toString() {
        return ValuePrinter.print(this);
    }
}

