/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.types.ReferenceTypeVisitor;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedAggregateType;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.util.Optionals;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.AbstractSerializedReferenceType;
import net.amygdalum.testrecorder.values.ValuePrinter;

public class SerializedSet
extends AbstractSerializedReferenceType
implements SerializedAggregateType,
Collection<SerializedValue> {
    private Type componentType = Object.class;
    private Set<SerializedValue> set = new LinkedHashSet<SerializedValue>();

    public SerializedSet(Class<?> type) {
        super(type);
    }

    @Override
    public List<SerializedValue> elements() {
        return new ArrayList<SerializedValue>(this.set);
    }

    public Type getComponentType() {
        return this.componentType;
    }

    private Stream<Type> getComponentTypeCandidates() {
        return Arrays.stream(this.getUsedTypes()).filter(type -> Types.typeArguments((Type)type).count() == 1L).flatMap(type -> Optionals.stream((Optional)Types.typeArgument((Type)type, (int)0)));
    }

    @Override
    public void useAs(Type type) {
        super.useAs(type);
        this.componentType = this.inferType(this.getComponentTypeCandidates(), this.set, Object.class);
    }

    @Override
    public <T> T accept(RoleVisitor<T> visitor) {
        return visitor.visitReferenceType(this);
    }

    @Override
    public <T> T accept(ReferenceTypeVisitor<T> visitor) {
        return visitor.visitAggregateType(this);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<SerializedValue> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean add(SerializedValue element) {
        boolean added = this.set.add(element);
        if (!this.satisfiesType(this.componentType, element)) {
            this.componentType = this.inferType(this.getComponentTypeCandidates(), this.set, Object.class);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends SerializedValue> c) {
        boolean added = this.set.addAll(c);
        if (!this.satisfiesType(this.componentType, c)) {
            this.componentType = this.inferType(this.getComponentTypeCandidates(), this.set, Object.class);
        }
        return added;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public List<SerializedValue> referencedValues() {
        return this.elements();
    }

    public String toString() {
        return ValuePrinter.print(this);
    }
}

