/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedArgument;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedImmutableType;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.SerializedResult;
import net.amygdalum.testrecorder.types.SerializedRole;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.SerializedValueType;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedEnum;
import net.amygdalum.testrecorder.values.SerializedImmutable;
import net.amygdalum.testrecorder.values.SerializedList;
import net.amygdalum.testrecorder.values.SerializedMap;
import net.amygdalum.testrecorder.values.SerializedNull;
import net.amygdalum.testrecorder.values.SerializedObject;
import net.amygdalum.testrecorder.values.SerializedProxy;
import net.amygdalum.testrecorder.values.SerializedSet;

public class ValuePrinter
implements RoleVisitor<String> {
    private Set<Object> known = new LinkedHashSet<Object>();

    public static String print(SerializedRole value) {
        ValuePrinter printer = new ValuePrinter();
        return value.accept(printer);
    }

    @Override
    public String visitField(SerializedField field) {
        return field.getType().getTypeName() + " " + field.getName() + ": " + field.getValue().accept(this);
    }

    @Override
    public String visitArgument(SerializedArgument argument) {
        return argument.getValue().accept(this);
    }

    @Override
    public String visitResult(SerializedResult result) {
        return result.getValue().accept(this);
    }

    @Override
    public String visitReferenceType(SerializedReferenceType rt) {
        boolean inserted = this.known.add(rt);
        if (!inserted) {
            return rt.getType() + "/" + System.identityHashCode(rt);
        }
        if (rt instanceof SerializedObject) {
            SerializedObject value = (SerializedObject)rt;
            return this.printObject(value);
        }
        if (rt instanceof SerializedProxy) {
            SerializedProxy value = (SerializedProxy)rt;
            return this.printProxy(value);
        }
        if (rt instanceof SerializedList) {
            SerializedList value = (SerializedList)rt;
            return this.printList(value);
        }
        if (rt instanceof SerializedMap) {
            SerializedMap value = (SerializedMap)rt;
            return this.printMap(value);
        }
        if (rt instanceof SerializedSet) {
            SerializedSet value = (SerializedSet)rt;
            return this.printSet(value);
        }
        if (rt instanceof SerializedArray) {
            SerializedArray value = (SerializedArray)rt;
            return this.printArray(value);
        }
        if (rt == SerializedNull.VOID) {
            return "void";
        }
        if (rt instanceof SerializedNull) {
            return "null";
        }
        return "?";
    }

    private String printProxy(SerializedProxy value) {
        return value.getType().toString().replace("class", "proxy") + "/" + System.identityHashCode(value);
    }

    private String printObject(SerializedObject value) {
        return value.getType().getTypeName() + "/" + System.identityHashCode(value) + " " + value.getFields().stream().sorted().map(field -> field.accept(this)).collect(Collectors.joining(",\n", "{\n", "\n}"));
    }

    private String printList(SerializedList value) {
        return value.stream().map(element -> element.accept(this)).collect(Collectors.joining(", ", "[", "]"));
    }

    private String printSet(SerializedSet value) {
        return value.stream().map(element -> element.accept(this)).collect(Collectors.joining(", ", "{", "}"));
    }

    private String printMap(SerializedMap value) {
        return value.entrySet().stream().map(element -> ((SerializedValue)element.getKey()).accept(this) + ":" + ((SerializedValue)element.getValue()).accept(this)).collect(Collectors.joining(",", "{", "}"));
    }

    private String printArray(SerializedArray value) {
        return Stream.of(value.getArray()).map(element -> element.accept(this)).collect(Collectors.joining(", ", "<", ">"));
    }

    @Override
    public String visitImmutableType(SerializedImmutableType rt) {
        if (rt instanceof SerializedImmutable) {
            SerializedImmutable value = (SerializedImmutable)rt;
            return value.getValue().toString();
        }
        if (rt instanceof SerializedEnum) {
            SerializedEnum value = (SerializedEnum)rt;
            return value.getName();
        }
        return "";
    }

    @Override
    public String visitValueType(SerializedValueType value) {
        return value.getValue().toString();
    }
}

