/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.amygdalum.testrecorder.runtime.Matches;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;

public class ContainsInOrderMatcher<T>
extends TypeSafeMatcher<Collection<? extends T>> {
    private Class<T> type;
    private List<Matcher<T>> elements;

    public ContainsInOrderMatcher(Class<T> type) {
        this.type = type;
        this.elements = new ArrayList<Matcher<T>>();
    }

    public ContainsInOrderMatcher<T> element(T element) {
        return this.element(this.match(element));
    }

    public ContainsInOrderMatcher<T> element(Matcher<T> element) {
        this.elements.add(element);
        return this;
    }

    private Matcher<T> match(T element) {
        if (element == null) {
            return IsNull.nullValue(this.type);
        }
        return IsEqual.equalTo(element);
    }

    public void describeTo(Description description) {
        description.appendText("containing in sequence ").appendValueList("[", ", ", "]", this.elements);
    }

    protected void describeMismatchSafely(Collection<? extends T> item, Description mismatchDescription) {
        Matches<T> matches = new Matches<T>();
        Iterator<Matcher<T>> elementIterator = this.elements.iterator();
        Iterator<T> itemIterator = item.iterator();
        while (elementIterator.hasNext() && itemIterator.hasNext()) {
            T element;
            Matcher<T> matcher = elementIterator.next();
            if (!matcher.matches(element = itemIterator.next())) {
                matches.mismatch(matcher, element);
                continue;
            }
            matches.match();
        }
        if (elementIterator.hasNext()) {
            int count = this.count(elementIterator);
            matches.mismatch("missing " + count + " elements");
        }
        if (itemIterator.hasNext()) {
            List<T> items = this.collect(itemIterator);
            matches.mismatch("found " + items.size() + " elements surplus " + this.toDescriptionSet(items));
        }
        if (matches.containsMismatches()) {
            mismatchDescription.appendText("mismatching elements ").appendDescriptionOf(matches);
        }
    }

    private int count(Iterator<?> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    private List<T> collect(Iterator<? extends T> iterator) {
        ArrayList<T> collected = new ArrayList<T>();
        while (iterator.hasNext()) {
            collected.add(iterator.next());
        }
        return collected;
    }

    private Set<String> toDescriptionSet(List<T> elements) {
        Matcher<T> matcher = this.bestMatcher();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (T element : elements) {
            String desc = this.descriptionOf(matcher, element);
            set.add(desc);
        }
        return set;
    }

    private Matcher<T> bestMatcher() {
        for (Matcher<T> matcher : this.elements) {
            if (matcher.getClass() == IsNull.class) continue;
            return matcher;
        }
        return IsEqual.equalTo(null);
    }

    private <S> String descriptionOf(Matcher<S> matcher, S value) {
        StringDescription description = new StringDescription();
        matcher.describeMismatch(value, (Description)description);
        return description.toString();
    }

    protected boolean matchesSafely(Collection<? extends T> item) {
        Iterator<Matcher<T>> elementIterator = this.elements.iterator();
        Iterator<T> itemIterator = item.iterator();
        while (elementIterator.hasNext() && itemIterator.hasNext()) {
            T element;
            Matcher<T> matcher = elementIterator.next();
            if (matcher.matches(element = itemIterator.next())) continue;
            return false;
        }
        return !elementIterator.hasNext() && !itemIterator.hasNext();
    }

    @SafeVarargs
    public static <T> ContainsInOrderMatcher<T> containsInOrder(Class<T> key, Object ... elements) {
        ContainsInOrderMatcher<T> set = new ContainsInOrderMatcher<T>(key);
        for (Object element : elements) {
            if (element instanceof Matcher) {
                set.element((Matcher)element);
                continue;
            }
            set.element(key.cast(element));
        }
        return set;
    }
}

